/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.mult;

import org.ejml.alg.fixed.FixedOps3;
import org.ejml.alg.fixed.FixedOps6;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.FixedMatrix3x3_64F;
import org.ejml.data.FixedMatrix6x6_64F;

public class MatrixMultFixedBlock {
    private FixedMatrix6x6_64F a0_6 = new FixedMatrix6x6_64F();
    private FixedMatrix6x6_64F a1_6 = new FixedMatrix6x6_64F();
    private FixedMatrix6x6_64F b00_6 = new FixedMatrix6x6_64F();
    private FixedMatrix6x6_64F b01_6 = new FixedMatrix6x6_64F();
    private FixedMatrix6x6_64F b10_6 = new FixedMatrix6x6_64F();
    private FixedMatrix6x6_64F b11_6 = new FixedMatrix6x6_64F();
    private FixedMatrix6x6_64F tmp_6 = new FixedMatrix6x6_64F();
    private FixedMatrix3x3_64F a0_3 = new FixedMatrix3x3_64F();
    private FixedMatrix3x3_64F a1_3 = new FixedMatrix3x3_64F();
    private FixedMatrix3x3_64F a2_3 = new FixedMatrix3x3_64F();
    private FixedMatrix3x3_64F a3_3 = new FixedMatrix3x3_64F();
    private FixedMatrix3x3_64F b00_3 = new FixedMatrix3x3_64F();
    private FixedMatrix3x3_64F b01_3 = new FixedMatrix3x3_64F();
    private FixedMatrix3x3_64F b02_3 = new FixedMatrix3x3_64F();
    private FixedMatrix3x3_64F b03_3 = new FixedMatrix3x3_64F();
    private FixedMatrix3x3_64F b10_3 = new FixedMatrix3x3_64F();
    private FixedMatrix3x3_64F b11_3 = new FixedMatrix3x3_64F();
    private FixedMatrix3x3_64F b12_3 = new FixedMatrix3x3_64F();
    private FixedMatrix3x3_64F b13_3 = new FixedMatrix3x3_64F();
    private FixedMatrix3x3_64F b20_3 = new FixedMatrix3x3_64F();
    private FixedMatrix3x3_64F b21_3 = new FixedMatrix3x3_64F();
    private FixedMatrix3x3_64F b22_3 = new FixedMatrix3x3_64F();
    private FixedMatrix3x3_64F b23_3 = new FixedMatrix3x3_64F();
    private FixedMatrix3x3_64F b30_3 = new FixedMatrix3x3_64F();
    private FixedMatrix3x3_64F b31_3 = new FixedMatrix3x3_64F();
    private FixedMatrix3x3_64F b32_3 = new FixedMatrix3x3_64F();
    private FixedMatrix3x3_64F b33_3 = new FixedMatrix3x3_64F();
    private FixedMatrix3x3_64F tmp_3 = new FixedMatrix3x3_64F();

    public void mult_2x6(DenseMatrix64F A, DenseMatrix64F B, DenseMatrix64F C) {
        MatrixMultFixedBlock.extract(A, this.a0_6, 0, 0);
        MatrixMultFixedBlock.extract(A, this.a1_6, 0, 6);
        MatrixMultFixedBlock.extract(B, this.b00_6, 0, 0);
        MatrixMultFixedBlock.extract(B, this.b01_6, 0, 6);
        MatrixMultFixedBlock.extract(B, this.b10_6, 6, 0);
        MatrixMultFixedBlock.extract(B, this.b11_6, 6, 6);
        FixedOps6.mult((FixedMatrix6x6_64F)this.a0_6, (FixedMatrix6x6_64F)this.b00_6, (FixedMatrix6x6_64F)this.tmp_6);
        FixedOps6.multAdd((FixedMatrix6x6_64F)this.a1_6, (FixedMatrix6x6_64F)this.b10_6, (FixedMatrix6x6_64F)this.tmp_6);
        MatrixMultFixedBlock.insert(this.tmp_6, C, 0, 0);
        FixedOps6.mult((FixedMatrix6x6_64F)this.a0_6, (FixedMatrix6x6_64F)this.b01_6, (FixedMatrix6x6_64F)this.tmp_6);
        FixedOps6.multAdd((FixedMatrix6x6_64F)this.a1_6, (FixedMatrix6x6_64F)this.b11_6, (FixedMatrix6x6_64F)this.tmp_6);
        MatrixMultFixedBlock.insert(this.tmp_6, C, 0, 6);
        MatrixMultFixedBlock.extract(A, this.a0_6, 6, 0);
        MatrixMultFixedBlock.extract(A, this.a1_6, 6, 6);
        FixedOps6.mult((FixedMatrix6x6_64F)this.a0_6, (FixedMatrix6x6_64F)this.b01_6, (FixedMatrix6x6_64F)this.tmp_6);
        FixedOps6.multAdd((FixedMatrix6x6_64F)this.a1_6, (FixedMatrix6x6_64F)this.b11_6, (FixedMatrix6x6_64F)this.tmp_6);
        MatrixMultFixedBlock.insert(this.tmp_6, C, 6, 6);
        FixedOps6.mult((FixedMatrix6x6_64F)this.a0_6, (FixedMatrix6x6_64F)this.b00_6, (FixedMatrix6x6_64F)this.tmp_6);
        FixedOps6.multAdd((FixedMatrix6x6_64F)this.a1_6, (FixedMatrix6x6_64F)this.b10_6, (FixedMatrix6x6_64F)this.tmp_6);
        MatrixMultFixedBlock.insert(this.tmp_6, C, 6, 0);
    }

    public void mult_4x3(DenseMatrix64F A, DenseMatrix64F B, DenseMatrix64F C) {
        MatrixMultFixedBlock.extract(B, this.b00_3, 0, 0);
        MatrixMultFixedBlock.extract(B, this.b01_3, 0, 3);
        MatrixMultFixedBlock.extract(B, this.b02_3, 0, 6);
        MatrixMultFixedBlock.extract(B, this.b03_3, 0, 9);
        MatrixMultFixedBlock.extract(B, this.b10_3, 3, 0);
        MatrixMultFixedBlock.extract(B, this.b11_3, 3, 3);
        MatrixMultFixedBlock.extract(B, this.b12_3, 3, 6);
        MatrixMultFixedBlock.extract(B, this.b13_3, 3, 9);
        MatrixMultFixedBlock.extract(B, this.b20_3, 6, 0);
        MatrixMultFixedBlock.extract(B, this.b21_3, 6, 3);
        MatrixMultFixedBlock.extract(B, this.b22_3, 6, 6);
        MatrixMultFixedBlock.extract(B, this.b23_3, 6, 9);
        MatrixMultFixedBlock.extract(B, this.b30_3, 9, 0);
        MatrixMultFixedBlock.extract(B, this.b31_3, 9, 3);
        MatrixMultFixedBlock.extract(B, this.b32_3, 9, 6);
        MatrixMultFixedBlock.extract(B, this.b33_3, 9, 9);
        this.computeRow_4x3(A, C, 0);
        this.computeRow_4x3(A, C, 3);
        this.computeRow_4x3(A, C, 6);
        this.computeRow_4x3(A, C, 9);
    }

    private void computeRow_4x3(DenseMatrix64F A, DenseMatrix64F C, int row) {
        MatrixMultFixedBlock.extract(A, this.a0_3, row, 0);
        MatrixMultFixedBlock.extract(A, this.a1_3, row, 3);
        MatrixMultFixedBlock.extract(A, this.a2_3, row, 6);
        MatrixMultFixedBlock.extract(A, this.a3_3, row, 9);
        FixedOps3.mult((FixedMatrix3x3_64F)this.a0_3, (FixedMatrix3x3_64F)this.b00_3, (FixedMatrix3x3_64F)this.tmp_3);
        FixedOps3.multAdd((FixedMatrix3x3_64F)this.a1_3, (FixedMatrix3x3_64F)this.b10_3, (FixedMatrix3x3_64F)this.tmp_3);
        FixedOps3.multAdd((FixedMatrix3x3_64F)this.a2_3, (FixedMatrix3x3_64F)this.b20_3, (FixedMatrix3x3_64F)this.tmp_3);
        FixedOps3.multAdd((FixedMatrix3x3_64F)this.a3_3, (FixedMatrix3x3_64F)this.b30_3, (FixedMatrix3x3_64F)this.tmp_3);
        MatrixMultFixedBlock.insert(this.tmp_3, C, row, 0);
        FixedOps3.mult((FixedMatrix3x3_64F)this.a0_3, (FixedMatrix3x3_64F)this.b01_3, (FixedMatrix3x3_64F)this.tmp_3);
        FixedOps3.multAdd((FixedMatrix3x3_64F)this.a1_3, (FixedMatrix3x3_64F)this.b11_3, (FixedMatrix3x3_64F)this.tmp_3);
        FixedOps3.multAdd((FixedMatrix3x3_64F)this.a2_3, (FixedMatrix3x3_64F)this.b21_3, (FixedMatrix3x3_64F)this.tmp_3);
        FixedOps3.multAdd((FixedMatrix3x3_64F)this.a3_3, (FixedMatrix3x3_64F)this.b31_3, (FixedMatrix3x3_64F)this.tmp_3);
        MatrixMultFixedBlock.insert(this.tmp_3, C, row, 3);
        FixedOps3.mult((FixedMatrix3x3_64F)this.a0_3, (FixedMatrix3x3_64F)this.b02_3, (FixedMatrix3x3_64F)this.tmp_3);
        FixedOps3.multAdd((FixedMatrix3x3_64F)this.a1_3, (FixedMatrix3x3_64F)this.b12_3, (FixedMatrix3x3_64F)this.tmp_3);
        FixedOps3.multAdd((FixedMatrix3x3_64F)this.a2_3, (FixedMatrix3x3_64F)this.b22_3, (FixedMatrix3x3_64F)this.tmp_3);
        FixedOps3.multAdd((FixedMatrix3x3_64F)this.a3_3, (FixedMatrix3x3_64F)this.b32_3, (FixedMatrix3x3_64F)this.tmp_3);
        MatrixMultFixedBlock.insert(this.tmp_3, C, row, 6);
        FixedOps3.mult((FixedMatrix3x3_64F)this.a0_3, (FixedMatrix3x3_64F)this.b03_3, (FixedMatrix3x3_64F)this.tmp_3);
        FixedOps3.multAdd((FixedMatrix3x3_64F)this.a1_3, (FixedMatrix3x3_64F)this.b13_3, (FixedMatrix3x3_64F)this.tmp_3);
        FixedOps3.multAdd((FixedMatrix3x3_64F)this.a2_3, (FixedMatrix3x3_64F)this.b23_3, (FixedMatrix3x3_64F)this.tmp_3);
        FixedOps3.multAdd((FixedMatrix3x3_64F)this.a3_3, (FixedMatrix3x3_64F)this.b33_3, (FixedMatrix3x3_64F)this.tmp_3);
        MatrixMultFixedBlock.insert(this.tmp_3, C, row, 9);
    }

    public static void extract(DenseMatrix64F A, FixedMatrix6x6_64F a, int row, int col) {
        int idx = row * A.numCols + col;
        a.a11 = A.data[idx++];
        a.a12 = A.data[idx++];
        a.a13 = A.data[idx++];
        a.a14 = A.data[idx++];
        a.a15 = A.data[idx++];
        a.a16 = A.data[idx];
        idx = (row + 1) * A.numCols + col;
        a.a21 = A.data[idx++];
        a.a22 = A.data[idx++];
        a.a23 = A.data[idx++];
        a.a24 = A.data[idx++];
        a.a25 = A.data[idx++];
        a.a26 = A.data[idx];
        idx = (row + 2) * A.numCols + col;
        a.a31 = A.data[idx++];
        a.a32 = A.data[idx++];
        a.a33 = A.data[idx++];
        a.a34 = A.data[idx++];
        a.a35 = A.data[idx++];
        a.a36 = A.data[idx];
        idx = (row + 3) * A.numCols + col;
        a.a41 = A.data[idx++];
        a.a42 = A.data[idx++];
        a.a43 = A.data[idx++];
        a.a44 = A.data[idx++];
        a.a45 = A.data[idx++];
        a.a46 = A.data[idx];
        idx = (row + 3) * A.numCols + col;
        a.a51 = A.data[idx++];
        a.a52 = A.data[idx++];
        a.a53 = A.data[idx++];
        a.a54 = A.data[idx++];
        a.a55 = A.data[idx++];
        a.a56 = A.data[idx];
        idx = (row + 4) * A.numCols + col;
        a.a61 = A.data[idx++];
        a.a62 = A.data[idx++];
        a.a63 = A.data[idx++];
        a.a64 = A.data[idx++];
        a.a65 = A.data[idx++];
        a.a66 = A.data[idx];
    }

    public static void insert(FixedMatrix6x6_64F a, DenseMatrix64F A, int row, int col) {
        int idx = row * A.numCols + col;
        A.data[idx++] = a.a11;
        A.data[idx++] = a.a12;
        A.data[idx++] = a.a13;
        A.data[idx++] = a.a14;
        A.data[idx++] = a.a15;
        A.data[idx] = a.a16;
        idx = (row + 1) * A.numCols + col;
        A.data[idx++] = a.a21;
        A.data[idx++] = a.a22;
        A.data[idx++] = a.a23;
        A.data[idx++] = a.a24;
        A.data[idx++] = a.a25;
        A.data[idx] = a.a26;
        idx = (row + 2) * A.numCols + col;
        A.data[idx++] = a.a31;
        A.data[idx++] = a.a32;
        A.data[idx++] = a.a33;
        A.data[idx++] = a.a34;
        A.data[idx++] = a.a35;
        A.data[idx] = a.a36;
        idx = (row + 3) * A.numCols + col;
        A.data[idx++] = a.a41;
        A.data[idx++] = a.a42;
        A.data[idx++] = a.a43;
        A.data[idx++] = a.a44;
        A.data[idx++] = a.a45;
        A.data[idx] = a.a46;
        idx = (row + 3) * A.numCols + col;
        A.data[idx++] = a.a51;
        A.data[idx++] = a.a52;
        A.data[idx++] = a.a53;
        A.data[idx++] = a.a54;
        A.data[idx++] = a.a55;
        A.data[idx] = a.a56;
        idx = (row + 4) * A.numCols + col;
        A.data[idx++] = a.a61;
        A.data[idx++] = a.a62;
        A.data[idx++] = a.a63;
        A.data[idx++] = a.a64;
        A.data[idx++] = a.a65;
        A.data[idx] = a.a66;
    }

    public static void extract(DenseMatrix64F A, FixedMatrix3x3_64F a, int row, int col) {
        int idx = row * A.numCols + col;
        a.a11 = A.data[idx++];
        a.a12 = A.data[idx++];
        a.a12 = A.data[idx];
        idx = (row + 1) * A.numCols + col;
        a.a21 = A.data[idx++];
        a.a22 = A.data[idx++];
        a.a23 = A.data[idx];
        idx = (row + 2) * A.numCols + col;
        a.a31 = A.data[idx++];
        a.a32 = A.data[idx++];
        a.a33 = A.data[idx];
    }

    public static void insert(FixedMatrix3x3_64F a, DenseMatrix64F A, int row, int col) {
        int idx = row * A.numCols + col;
        A.data[idx++] = a.a11;
        A.data[idx++] = a.a12;
        A.data[idx] = a.a13;
        idx = (row + 1) * A.numCols + col;
        A.data[idx++] = a.a21;
        A.data[idx++] = a.a22;
        A.data[idx] = a.a23;
        idx = (row + 2) * A.numCols + col;
        A.data[idx++] = a.a31;
        A.data[idx++] = a.a32;
        A.data[idx] = a.a33;
    }
}

