/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.densed2.mult;

import org.ejml.data.DenseD2Matrix64F;
import org.ejml.ops.MatrixDimensionException;

public class MatrixMatrixMult_D2 {
    public static void mult_small(DenseD2Matrix64F a, DenseD2Matrix64F b, DenseD2Matrix64F c) {
        if (a.numCols != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numRows != c.numRows || b.numCols != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        double[][] dataA = a.data;
        double[][] dataB = b.data;
        double[][] dataR = c.data;
        for (int i = 0; i < a.numRows; ++i) {
            double[] dataAi = dataA[i];
            double[] dataRi = dataR[i];
            for (int j = 0; j < b.numCols; ++j) {
                double total = 0.0;
                for (int k = 0; k < a.numCols; ++k) {
                    total += dataAi[k] * dataB[k][j];
                }
                dataRi[j] = total;
            }
        }
    }

    public static void mult_aux(DenseD2Matrix64F a, DenseD2Matrix64F b, DenseD2Matrix64F c, double[] aux) {
        if (a.numCols != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numRows != c.numRows || b.numCols != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (aux == null) {
            aux = new double[b.numRows];
        }
        double[][] dataA = a.data;
        double[][] dataB = b.data;
        double[][] dataR = c.data;
        for (int j = 0; j < b.numCols; ++j) {
            for (int k = 0; k < b.numRows; ++k) {
                aux[k] = dataB[k][j];
            }
            for (int i = 0; i < a.numRows; ++i) {
                double[] dataAi = dataA[i];
                double total = 0.0;
                int k = 0;
                while (k < b.numRows) {
                    total += dataAi[k] * aux[k++];
                }
                dataR[i][j] = total;
            }
        }
    }
}

