/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.spring;

import org.ektorp.http.HttpClient;
import org.ektorp.http.StdHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Value;

public class HttpClientFactoryBean
implements FactoryBean<HttpClient> {
    private static final Logger LOG = LoggerFactory.getLogger(HttpClientFactoryBean.class);
    @Value(value="#{couchdbProperties.host}")
    public String host;
    @Value(value="#{couchdbProperties.port}")
    public int port;
    @Value(value="#{couchdbProperties.maxConnections}")
    public int maxConnections;
    @Value(value="#{couchdbProperties.connectionTimeout}")
    public int connectionTimeout = 1000;
    @Value(value="#{couchdbProperties.socketTimeout}")
    public int socketTimeout = 10000;

    public HttpClient getObject() throws Exception {
        LOG.debug("host: {}", (Object)this.host);
        LOG.debug("port: {}", (Object)this.port);
        LOG.debug("maxConnections: {}", (Object)this.maxConnections);
        LOG.debug("connectionTimeout: {}", (Object)this.connectionTimeout);
        LOG.debug("socketTimeout: {}", (Object)this.socketTimeout);
        HttpClient client = new StdHttpClient.Builder().host(this.host).port(this.port).maxConnections(this.maxConnections).connectionTimeout(this.connectionTimeout).socketTimeout(this.socketTimeout).build();
        this.testConnect(client);
        return client;
    }

    private void testConnect(HttpClient client) {
        try {
            client.head("/");
        }
        catch (Exception e) {
            throw new BeanCreationException(String.format("Cannot connect to CouchDb@%s:%s", this.host, this.port), (Throwable)e);
        }
    }

    public Class<? extends HttpClient> getObjectType() {
        return HttpClient.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

