/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.spring;

import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.ektorp.dataload.DataLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.stereotype.Component;

@Component(value="initialDataLoader")
public class InitialDataLoader {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final List<DataLoader> loaders;
    private final ResourceLoader resources;

    @Autowired
    public InitialDataLoader(List<DataLoader> l, ResourceLoader rl) {
        this.loaders = l;
        this.resources = rl;
    }

    @PostConstruct
    public void loadData() {
        ExecutorService es = Executors.newFixedThreadPool(this.loaders.size(), (ThreadFactory)new CustomizableThreadFactory("initial-dataloader-"));
        for (DataLoader l : this.loaders) {
            es.submit(new LoaderTask(l));
        }
        es.shutdown();
        try {
            this.afterLoad(es);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private void afterLoad(ExecutorService es) throws InterruptedException {
        es.awaitTermination(5L, TimeUnit.MINUTES);
        if (es.isTerminated()) {
            for (DataLoader l : this.loaders) {
                l.allDataLoaded();
            }
        } else {
            this.log.error("The following data loaders did not complete in time: ");
            for (Runnable r : es.shutdownNow()) {
                this.log.error("The following data loaders did not complete in time: {}", (Object)r);
            }
        }
    }

    private class LoaderTask
    implements Runnable {
        final DataLoader loader;

        LoaderTask(DataLoader l) {
            this.loader = l;
        }

        @Override
        public void run() {
            for (String location : this.loader.getDataLocations()) {
                Resource data = InitialDataLoader.this.resources.getResource(location);
                if (data.exists()) {
                    try {
                        InitialDataLoader.this.log.info("loading data from {}", (Object)data.getDescription());
                        this.loader.loadInitialData((Reader)new InputStreamReader(data.getInputStream(), UTF_8));
                    }
                    catch (Exception e) {
                        InitialDataLoader.this.log.error("Failed to load data from : " + location, (Throwable)e);
                    }
                    continue;
                }
                InitialDataLoader.this.log.error("Failed to load data from {} does not exists", (Object)data.getDescription());
            }
        }

        public String toString() {
            return "LoaderTask: " + this.loader.getClass().getSimpleName();
        }
    }
}

