/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.spring;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.ektorp.UpdateConflictException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;

@Aspect
public class RetryAdvice
implements Ordered {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final int DEFAULT_MAX_RETRIES = 2;
    private int maxRetries = 2;

    @Pointcut(value="@annotation(org.ektorp.Retryable)")
    public void retryableDbOperation() {
    }

    @Around(value="org.ektorp.spring.RetryAdvice.retryableDbOperation()")
    public Object retryAfterUpdateConflict(ProceedingJoinPoint pjp) throws Throwable {
        int numAttempts = 0;
        while (true) {
            ++numAttempts;
            try {
                this.log.debug("proceeding join point: {}", (Object)pjp.toShortString());
                return pjp.proceed();
            }
            catch (UpdateConflictException e) {
                this.log.warn("{} experienced update conflict. attempt: {}", (Object)pjp.toShortString(), (Object)numAttempts);
                UpdateConflictException conflictException = e;
                if (numAttempts < this.maxRetries) continue;
                throw conflictException;
            }
            break;
        }
    }

    public int getOrder() {
        return 0;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }
}

