/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.spring;

import org.apache.http.conn.ssl.SSLSocketFactory;
import org.ektorp.http.HttpClient;
import org.ektorp.http.StdHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpClientFactoryBean
implements FactoryBean<HttpClient> {
    private static final Logger LOG = LoggerFactory.getLogger(HttpClientFactoryBean.class);
    @Value(value="#{couchdbProperties['host']?:'localhost'}")
    public String host;
    @Value(value="#{couchdbProperties['port']?:5984}")
    public int port;
    @Value(value="#{couchdbProperties['maxConnections']?:20}")
    public int maxConnections;
    @Value(value="#{couchdbProperties['connectionTimeout']?:1000}")
    public int connectionTimeout;
    @Value(value="#{couchdbProperties['socketTimeout']?:10000}")
    public int socketTimeout;
    @Value(value="#{couchdbProperties['autoUpdateViewOnChange']?:false}")
    public boolean autoUpdateViewOnChange;
    @Value(value="#{couchdbProperties['username']}")
    public String username;
    @Value(value="#{couchdbProperties['password']}")
    public String password;
    @Value(value="#{couchdbProperties['testConnectionAtStartup']?:false}")
    public boolean testConnectionAtStartup;
    @Value(value="#{couchdbProperties['cleanupIdleConnections']?:true}")
    public boolean cleanupIdleConnections;
    @Value(value="#{couchdbProperties['enableSSL']?:false}")
    public boolean enableSSL;
    @Value(value="#{couchdbProperties['relaxedSSLSettings']?:false}")
    public boolean relaxedSSLSettings;
    private SSLSocketFactory sslSocketFactory;

    public HttpClient getObject() throws Exception {
        LOG.debug("host: {}", (Object)this.host);
        LOG.debug("port: {}", (Object)this.port);
        LOG.debug("maxConnections: {}", (Object)this.maxConnections);
        LOG.debug("connectionTimeout: {}", (Object)this.connectionTimeout);
        LOG.debug("socketTimeout: {}", (Object)this.socketTimeout);
        LOG.debug("autoUpdateViewOnChange: {}", (Object)this.autoUpdateViewOnChange);
        LOG.debug("testConnectionAtStartup: {}", (Object)this.testConnectionAtStartup);
        LOG.debug("cleanupIdleConnections: {}", (Object)this.cleanupIdleConnections);
        LOG.debug("enableSSL: {}", (Object)this.enableSSL);
        LOG.debug("relaxedSSLSettings: {}", (Object)this.relaxedSSLSettings);
        HttpClient client = new StdHttpClient.Builder().host(this.host).port(this.port).maxConnections(this.maxConnections).connectionTimeout(this.connectionTimeout).socketTimeout(this.socketTimeout).username(this.username).password(this.password).cleanupIdleConnections(this.cleanupIdleConnections).enableSSL(this.enableSSL).relaxedSSLSettings(this.relaxedSSLSettings).sslSocketFactory(this.sslSocketFactory).build();
        if (this.testConnectionAtStartup) {
            this.testConnect(client);
        }
        this.configureAutoUpdateViewOnChange();
        return client;
    }

    private void configureAutoUpdateViewOnChange() {
        if (this.autoUpdateViewOnChange && !Boolean.getBoolean("org.ektorp.support.AutoUpdateViewOnChange")) {
            System.setProperty("org.ektorp.support.AutoUpdateViewOnChange", Boolean.TRUE.toString());
        }
    }

    private void testConnect(HttpClient client) {
        try {
            client.head("/");
        }
        catch (Exception e) {
            throw new BeanCreationException(String.format("Cannot connect to CouchDb@%s:%s", this.host, this.port), (Throwable)e);
        }
    }

    public Class<? extends HttpClient> getObjectType() {
        return HttpClient.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setAutoUpdateViewOnChange(boolean b) {
        this.autoUpdateViewOnChange = b;
    }

    public void setUsername(String user) {
        this.username = user;
    }

    public void setPassword(String s) {
        this.password = s;
    }

    public void setTestConnectionAtStartup(boolean b) {
        this.testConnectionAtStartup = b;
    }

    public void setSslSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
    }
}

