/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.spring;

import java.util.Map;
import java.util.Properties;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.ektorp.http.HttpClient;
import org.ektorp.http.ResponseCallback;
import org.ektorp.http.RestTemplate;
import org.ektorp.http.StdHttpClient;
import org.ektorp.http.StdResponseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class HttpClientFactoryBean
implements FactoryBean<HttpClient>,
InitializingBean,
DisposableBean {
    private static final Logger LOG = LoggerFactory.getLogger(HttpClientFactoryBean.class);
    protected HttpClient client;
    public String url;
    public String host = "localhost";
    public int port = 5984;
    public int maxConnections = 20;
    public int connectionTimeout = 1000;
    public int socketTimeout = 10000;
    public boolean autoUpdateViewOnChange;
    public String username;
    public String password;
    public boolean testConnectionAtStartup;
    public boolean cleanupIdleConnections = true;
    public boolean enableSSL = false;
    public boolean relaxedSSLSettings;
    public boolean caching = true;
    public int maxCacheEntries = 1000;
    public int maxObjectSizeBytes = 8192;
    private SSLSocketFactory sslSocketFactory;
    private Properties couchDBProperties;

    public HttpClient getObject() throws Exception {
        return this.client;
    }

    private void configureAutoUpdateViewOnChange() {
        if (this.autoUpdateViewOnChange && !Boolean.getBoolean("org.ektorp.support.AutoUpdateViewOnChange")) {
            System.setProperty("org.ektorp.support.AutoUpdateViewOnChange", Boolean.TRUE.toString());
        }
    }

    private void testConnect(HttpClient client) {
        try {
            RestTemplate rt = new RestTemplate(client);
            rt.head("/", (ResponseCallback)new StdResponseHandler());
        }
        catch (Exception e) {
            throw new BeanCreationException(String.format("Cannot connect to CouchDb@%s:%s", this.host, this.port), (Throwable)e);
        }
    }

    public Class<? extends HttpClient> getObjectType() {
        return HttpClient.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setAutoUpdateViewOnChange(boolean b) {
        this.autoUpdateViewOnChange = b;
    }

    public void setUsername(String user) {
        this.username = user;
    }

    public void setPassword(String s) {
        this.password = s;
    }

    public void setTestConnectionAtStartup(boolean b) {
        this.testConnectionAtStartup = b;
    }

    public void setSslSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public void setCleanupIdleConnections(boolean cleanupIdleConnections) {
        this.cleanupIdleConnections = cleanupIdleConnections;
    }

    public void setEnableSSL(boolean enableSSL) {
        this.enableSSL = enableSSL;
    }

    public void setRelaxedSSLSettings(boolean relaxedSSLSettings) {
        this.relaxedSSLSettings = relaxedSSLSettings;
    }

    public void setCaching(boolean caching) {
        this.caching = caching;
    }

    public void setMaxCacheEntries(int maxCacheEntries) {
        this.maxCacheEntries = maxCacheEntries;
    }

    public void setMaxObjectSizeBytes(int maxObjectSizeBytes) {
        this.maxObjectSizeBytes = maxObjectSizeBytes;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setProperties(Properties p) {
        this.couchDBProperties = p;
    }

    public void destroy() throws Exception {
        LOG.info("Stopping couchDb connector...");
        if (this.client != null) {
            this.client.shutdown();
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (this.couchDBProperties != null) {
            new DirectFieldAccessor((Object)this).setPropertyValues((Map)this.couchDBProperties);
        }
        LOG.info("Starting couchDb connector on {}:{}...", new Object[]{this.host, this.port});
        LOG.debug("host: {}", (Object)this.host);
        LOG.debug("port: {}", (Object)this.port);
        LOG.debug("url: {}", (Object)this.url);
        LOG.debug("maxConnections: {}", (Object)this.maxConnections);
        LOG.debug("connectionTimeout: {}", (Object)this.connectionTimeout);
        LOG.debug("socketTimeout: {}", (Object)this.socketTimeout);
        LOG.debug("autoUpdateViewOnChange: {}", (Object)this.autoUpdateViewOnChange);
        LOG.debug("testConnectionAtStartup: {}", (Object)this.testConnectionAtStartup);
        LOG.debug("cleanupIdleConnections: {}", (Object)this.cleanupIdleConnections);
        LOG.debug("enableSSL: {}", (Object)this.enableSSL);
        LOG.debug("relaxedSSLSettings: {}", (Object)this.relaxedSSLSettings);
        this.client = new StdHttpClient.Builder().host(this.host).port(this.port).maxConnections(this.maxConnections).connectionTimeout(this.connectionTimeout).socketTimeout(this.socketTimeout).username(this.username).password(this.password).cleanupIdleConnections(this.cleanupIdleConnections).enableSSL(this.enableSSL).relaxedSSLSettings(this.relaxedSSLSettings).sslSocketFactory(this.sslSocketFactory).caching(this.caching).maxCacheEntries(this.maxCacheEntries).maxObjectSizeBytes(this.maxObjectSizeBytes).url(this.url).build();
        if (this.testConnectionAtStartup) {
            this.testConnect(this.client);
        }
        this.configureAutoUpdateViewOnChange();
    }
}

