/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp;

import java.io.InputStream;
import java.io.Serializable;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.annotate.JsonWriteNullProperties;
import org.ektorp.util.Assert;

@JsonWriteNullProperties(value=false)
public class Attachment
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String id;
    private String contentType;
    private int length;
    private transient InputStream data;
    private String dataBase64;
    private boolean stub;
    private int revpos;

    public Attachment(String id, InputStream data, String contentType, int contentLength) {
        Assert.hasText(id, "attachmentId must have a value");
        Assert.hasText(contentType, "contentType must have a value");
        Assert.notNull(data, "data input stream cannot be null");
        this.id = id;
        this.data = data;
        this.contentType = contentType;
        this.length = contentLength;
    }

    public Attachment(String id, String data, String contentType) {
        Assert.hasText(id, "attachmentId must have a value");
        Assert.hasText(contentType, "contentType must have a value");
        Assert.notNull(data, "data input stream cannot be null");
        this.id = id;
        this.contentType = contentType;
        this.dataBase64 = data;
        this.length = data.getBytes().length;
    }

    Attachment() {
    }

    @JsonProperty(value="content_type")
    public String getContentType() {
        return this.contentType;
    }

    @JsonProperty(value="content_type")
    void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @JsonIgnore
    public int getLength() {
        return this.length;
    }

    @JsonProperty(value="data")
    public String getDataBase64() {
        return this.dataBase64;
    }

    @JsonIgnore
    public InputStream getData() {
        return this.data;
    }

    @JsonIgnore
    public String getId() {
        return this.id;
    }

    @JsonIgnore
    void setId(String id) {
        this.id = id;
    }

    void setLength(int contentLength) {
        this.length = contentLength;
    }

    public boolean isStub() {
        return this.stub;
    }

    void setStub(boolean stub) {
        this.stub = stub;
    }

    public int getRevpos() {
        return this.revpos;
    }

    public void setRevpos(int revpos) {
        this.revpos = revpos;
    }
}

