/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.ektorp.util.Assert;
import org.ektorp.util.Exceptions;

public class DbPath {
    private static final String UTF_8 = "UTF-8";
    private static final String DB_NAME_PATTERN = "^[\\w+-_\\$()]+(/[\\w+-_\\$()]+)*$";
    private static final String SPECIAL_DOC_PREFIX = "_";
    private final String dbName;
    private final String path;
    private final String allDocs;

    public DbPath(String s) {
        Assert.notNull(s);
        this.checkDbName(s);
        int start = s.startsWith("/") ? 1 : 0;
        int end = s.endsWith("/") ? s.length() - 1 : s.length();
        this.dbName = s.substring(start, end).toLowerCase();
        this.path = "/" + DbPath.escape(this.dbName) + "/";
        this.allDocs = this.path + "_all_docs";
    }

    public String append(String s) {
        return this.path + DbPath.escape(s);
    }

    public String getPath() {
        return this.path;
    }

    private static String escape(String s) {
        if (s.startsWith(SPECIAL_DOC_PREFIX)) {
            return s;
        }
        try {
            return URLEncoder.encode(s, UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            throw Exceptions.propagate(e);
        }
    }

    public static DbPath fromString(String s) {
        return new DbPath(s);
    }

    private void checkDbName(String path) {
        Assert.isTrue(path.matches(DB_NAME_PATTERN), String.format("Invalid database name: %s", path));
    }

    public String getAllDocsPath() {
        return this.allDocs;
    }

    public String getDbName() {
        return this.dbName;
    }
}

