/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.regex.Pattern;
import org.ektorp.util.Exceptions;

public class ViewQuery {
    private static final int NOT_SET = -1;
    private static final String QUOTE = "\"";
    private static final Pattern isJSONPattern = Pattern.compile("^[\\[{\"].+[\\]}\"]$");
    private String dbPath;
    private String designDocId;
    private String viewName;
    private String key;
    private String startKey;
    private String startDocId;
    private String endKey;
    private String endDocId;
    private int limit = -1;
    private boolean staleOk;
    private boolean descending;
    private int skip = -1;
    private boolean group;
    private int groupLevel = -1;
    private boolean reduce = true;
    private boolean includeDocs = false;
    private boolean inclusiveEnd = true;
    private boolean paramAppended;
    private String cachedQuery;

    public ViewQuery dbPath(String s) {
        this.reset();
        this.dbPath = s;
        return this;
    }

    public ViewQuery designDocId(String s) {
        this.reset();
        this.designDocId = s;
        return this;
    }

    public ViewQuery viewName(String s) {
        this.reset();
        this.viewName = s;
        return this;
    }

    public ViewQuery key(String s) {
        this.reset();
        this.key = this.urlEncodeJson(s);
        return this;
    }

    private String jsonEncode(String s) {
        if (!isJSONPattern.matcher(s).matches()) {
            return QUOTE + s + QUOTE;
        }
        return s;
    }

    private String urlEncodeJson(String s) {
        try {
            return URLEncoder.encode(this.jsonEncode(s), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw Exceptions.propagate(e);
        }
    }

    public ViewQuery startKey(String s) {
        this.reset();
        this.startKey = this.urlEncodeJson(s);
        return this;
    }

    public ViewQuery startDocId(String s) {
        this.reset();
        this.startDocId = s;
        return this;
    }

    public ViewQuery endKey(String s) {
        this.reset();
        this.endKey = this.urlEncodeJson(s);
        return this;
    }

    public ViewQuery endDocId(String s) {
        this.reset();
        this.endDocId = s;
        return this;
    }

    public ViewQuery limit(int i) {
        this.reset();
        this.limit = i;
        return this;
    }

    public ViewQuery staleOk(boolean b) {
        this.reset();
        this.staleOk = b;
        return this;
    }

    public ViewQuery descending(boolean b) {
        this.reset();
        this.descending = b;
        return this;
    }

    public ViewQuery skip(int i) {
        this.reset();
        this.skip = i;
        return this;
    }

    public ViewQuery group(boolean b) {
        this.reset();
        this.group = b;
        return this;
    }

    public ViewQuery groupLevel(int i) {
        this.reset();
        this.groupLevel = i;
        return this;
    }

    public ViewQuery reduce(boolean b) {
        this.reset();
        this.reduce = b;
        return this;
    }

    public ViewQuery includeDocs(boolean b) {
        this.reset();
        this.includeDocs = b;
        return this;
    }

    public ViewQuery inclusiveEnd(boolean b) {
        this.reset();
        this.inclusiveEnd = b;
        return this;
    }

    public void reset() {
        this.paramAppended = false;
        this.cachedQuery = null;
    }

    public String getKey() {
        return this.key;
    }

    public String getStartKey() {
        return this.startKey;
    }

    public String getEndKey() {
        return this.endKey;
    }

    public String buildQuery() {
        if (this.cachedQuery != null) {
            return this.cachedQuery;
        }
        StringBuilder query = this.buildViewPath();
        if (this.isNotEmpty(this.key)) {
            this.appendParameter(query, "key=", this.key);
        }
        if (this.isNotEmpty(this.startKey)) {
            this.appendParameter(query, "startkey=", this.startKey);
        }
        if (this.isNotEmpty(this.endKey)) {
            this.appendParameter(query, "endkey=", this.endKey);
        }
        if (this.isNotEmpty(this.startDocId)) {
            this.appendParameter(query, "startkey_docid=", this.startDocId);
        }
        if (this.isNotEmpty(this.endDocId)) {
            this.appendParameter(query, "endkey_docid=", this.endDocId);
        }
        if (this.hasValue(this.limit)) {
            this.appendParameter(query, "limit=", this.limit);
        }
        if (this.staleOk) {
            this.appendParameter(query, "stale=ok");
        }
        if (this.descending) {
            this.appendParameter(query, "descending=true");
        }
        if (!this.inclusiveEnd) {
            this.appendParameter(query, "inclusive_end=false");
        }
        if (!this.reduce) {
            this.appendParameter(query, "reduce=false");
        }
        if (this.hasValue(this.skip)) {
            this.appendParameter(query, "skip=", this.skip);
        }
        if (this.includeDocs) {
            this.appendParameter(query, "include_docs=true");
        }
        if (this.group) {
            this.appendParameter(query, "group=true");
        }
        if (this.hasValue(this.groupLevel)) {
            this.appendParameter(query, "group_level=", this.groupLevel);
        }
        this.cachedQuery = query.toString();
        return this.cachedQuery;
    }

    private void appendParameter(StringBuilder query, String param) {
        this.appendSeparator(query);
        query.append(param);
    }

    private void appendParameter(StringBuilder query, String paramName, String paramValue) {
        this.appendSeparator(query);
        query.append(paramName);
        query.append(paramValue);
    }

    private void appendParameter(StringBuilder query, String paramName, int paramValue) {
        this.appendSeparator(query);
        query.append(paramName);
        query.append(paramValue);
    }

    private void appendSeparator(StringBuilder query) {
        if (this.paramAppended) {
            query.append("&");
        } else {
            query.append("?");
        }
        this.paramAppended = true;
    }

    private StringBuilder buildViewPath() {
        this.assertHasText(this.dbPath, "dbPath");
        this.assertHasText(this.designDocId, "designDocId");
        this.assertHasText(this.viewName, "viewName");
        StringBuilder query = new StringBuilder().append(this.dbPath).append(this.designDocId).append("/_view/").append(this.viewName);
        return query;
    }

    private void assertHasText(String s, String fieldName) {
        if (s == null || s.length() == 0) {
            throw new IllegalStateException(String.format("%s must have a value", fieldName));
        }
    }

    private boolean hasValue(int i) {
        return i != -1;
    }

    private boolean isNotEmpty(String s) {
        return s != null && s.length() > 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dbPath == null ? 0 : this.dbPath.hashCode());
        result = 31 * result + (this.descending ? 1231 : 1237);
        result = 31 * result + (this.designDocId == null ? 0 : this.designDocId.hashCode());
        result = 31 * result + (this.endDocId == null ? 0 : this.endDocId.hashCode());
        result = 31 * result + (this.endKey == null ? 0 : this.endKey.hashCode());
        result = 31 * result + (this.group ? 1231 : 1237);
        result = 31 * result + this.groupLevel;
        result = 31 * result + (this.includeDocs ? 1231 : 1237);
        result = 31 * result + (this.inclusiveEnd ? 1231 : 1237);
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + this.limit;
        result = 31 * result + (this.paramAppended ? 1231 : 1237);
        result = 31 * result + (this.reduce ? 1231 : 1237);
        result = 31 * result + this.skip;
        result = 31 * result + (this.staleOk ? 1231 : 1237);
        result = 31 * result + (this.startDocId == null ? 0 : this.startDocId.hashCode());
        result = 31 * result + (this.startKey == null ? 0 : this.startKey.hashCode());
        result = 31 * result + (this.viewName == null ? 0 : this.viewName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ViewQuery other = (ViewQuery)obj;
        if (this.dbPath == null ? other.dbPath != null : !this.dbPath.equals(other.dbPath)) {
            return false;
        }
        if (this.descending != other.descending) {
            return false;
        }
        if (this.designDocId == null ? other.designDocId != null : !this.designDocId.equals(other.designDocId)) {
            return false;
        }
        if (this.endDocId == null ? other.endDocId != null : !this.endDocId.equals(other.endDocId)) {
            return false;
        }
        if (this.endKey == null ? other.endKey != null : !this.endKey.equals(other.endKey)) {
            return false;
        }
        if (this.group != other.group) {
            return false;
        }
        if (this.groupLevel != other.groupLevel) {
            return false;
        }
        if (this.includeDocs != other.includeDocs) {
            return false;
        }
        if (this.inclusiveEnd != other.inclusiveEnd) {
            return false;
        }
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        if (this.limit != other.limit) {
            return false;
        }
        if (this.paramAppended != other.paramAppended) {
            return false;
        }
        if (this.reduce != other.reduce) {
            return false;
        }
        if (this.skip != other.skip) {
            return false;
        }
        if (this.staleOk != other.staleOk) {
            return false;
        }
        if (this.startDocId == null ? other.startDocId != null : !this.startDocId.equals(other.startDocId)) {
            return false;
        }
        if (this.startKey == null ? other.startKey != null : !this.startKey.equals(other.startKey)) {
            return false;
        }
        return !(this.viewName == null ? other.viewName != null : !this.viewName.equals(other.viewName));
    }
}

