/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.http;

import java.io.InputStream;
import org.ektorp.http.HttpClient;
import org.ektorp.http.HttpResponse;
import org.ektorp.http.ResponseCallback;
import org.ektorp.http.StdResponseHandler;
import org.ektorp.util.Exceptions;

public class RestTemplate {
    private final HttpClient client;

    public RestTemplate(HttpClient client) {
        this.client = client;
    }

    public <T> T get(String path, ResponseCallback<T> callback) {
        HttpResponse hr = this.client.get(path);
        return this.handleResponse(callback, hr);
    }

    public HttpResponse get(String path) {
        HttpResponse hr = this.client.get(path);
        try {
            return hr.isSuccessful() ? hr : null;
        }
        catch (Exception e) {
            hr.releaseConnection();
            throw Exceptions.propagate(e);
        }
    }

    public void put(String path) {
        this.handleVoidResponse(this.client.put(path));
    }

    public <T> void put(String path, String content, ResponseCallback<T> callback) {
        this.handleVoidResponse(callback, this.client.put(path, content));
    }

    public void put(String path, String content) {
        this.handleVoidResponse(this.client.put(path, content));
    }

    public void put(String path, InputStream data, String contentType, int contentLength) {
        this.handleVoidResponse(this.client.put(path, data, contentType, contentLength));
    }

    public <T> T put(String path, InputStream data, String contentType, int contentLength, ResponseCallback<T> callback) {
        return this.handleResponse(callback, this.client.put(path, data, contentType, contentLength));
    }

    public <T> void post(String path, String content, ResponseCallback<T> callback) {
        this.handleVoidResponse(callback, this.client.post(path, content));
    }

    public <T> T delete(String path, ResponseCallback<T> callback) {
        return this.handleResponse(callback, this.client.delete(path));
    }

    public void delete(String path) {
        this.handleVoidResponse(this.client.delete(path));
    }

    public <T> T head(String path, ResponseCallback<T> callback) {
        return this.handleResponse(callback, this.client.head(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleVoidResponse(HttpResponse hr) {
        if (hr == null) {
            return;
        }
        try {
            if (!hr.isSuccessful()) {
                new StdResponseHandler().error(hr);
            }
        }
        finally {
            hr.releaseConnection();
        }
    }

    private <T> void handleVoidResponse(ResponseCallback<T> callback, HttpResponse hr) {
        try {
            if (hr.isSuccessful()) {
                callback.success(hr);
            } else {
                callback.error(hr);
            }
        }
        catch (Exception e) {
            throw Exceptions.propagate(e);
        }
        finally {
            hr.releaseConnection();
        }
    }

    private <T> T handleResponse(ResponseCallback<T> callback, HttpResponse hr) {
        try {
            T t = hr.isSuccessful() ? callback.success(hr) : callback.error(hr);
            return t;
        }
        catch (Exception e) {
            throw Exceptions.propagate(e);
        }
        finally {
            hr.releaseConnection();
        }
    }
}

