/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.impl;

import org.codehaus.jackson.map.ObjectMapper;
import org.ektorp.util.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSerializer {
    private final Logger LOG = LoggerFactory.getLogger(JsonSerializer.class);
    private final ObjectMapper objectMapper;

    public JsonSerializer(ObjectMapper om) {
        this.objectMapper = om;
    }

    public String toJson(Object o) {
        try {
            if (this.LOG.isDebugEnabled()) {
                String json = this.objectMapper.writeValueAsString(o);
                this.LOG.debug(json);
                return json;
            }
            return this.objectMapper.writeValueAsString(o);
        }
        catch (Exception e) {
            throw Exceptions.propagate(e);
        }
    }
}

