/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.impl;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.ektorp.Attachment;
import org.ektorp.CouchDbConnector;
import org.ektorp.CouchDbInstance;
import org.ektorp.DbAccessException;
import org.ektorp.DbPath;
import org.ektorp.DocumentExistsException;
import org.ektorp.Revision;
import org.ektorp.UpdateConflictException;
import org.ektorp.ViewQuery;
import org.ektorp.ViewResult;
import org.ektorp.http.HttpResponse;
import org.ektorp.http.ResponseCallback;
import org.ektorp.http.RestTemplate;
import org.ektorp.http.StdResponseHandler;
import org.ektorp.impl.JsonSerializer;
import org.ektorp.impl.RevisionResponseHandler;
import org.ektorp.util.Assert;
import org.ektorp.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StdCouchDbConnector
implements CouchDbConnector {
    private static final int DOCUMENT_NOT_FOUND_RESPONSE = 404;
    private static final int UPDATE_CONFLICT_RESPONSE = 409;
    private static final Logger LOG = LoggerFactory.getLogger(StdCouchDbConnector.class);
    private final JsonFactory jsonFactory;
    private final ObjectMapper objectMapper;
    private final JsonSerializer jsonSerializer;
    private DbPath dbPath;
    private final RestTemplate restTemplate;
    private final CouchDbInstance dbInstance;
    private RevisionResponseHandler revisionHandler;

    public StdCouchDbConnector(String databaseName, CouchDbInstance dbInstance) {
        this(databaseName, dbInstance, new ObjectMapper());
        this.objectMapper.configure(SerializationConfig.Feature.WRITE_DATES_AS_TIMESTAMPS, false);
    }

    public StdCouchDbConnector(String databaseName, CouchDbInstance dbi, ObjectMapper om) {
        Assert.hasText(databaseName, "DatabaseName cannot be empty");
        Assert.notNull(dbi, "CouchDbInstance cannot be null");
        Assert.hasText(databaseName, "JsonFactory cannot be null");
        this.dbPath = new DbPath(databaseName);
        this.dbInstance = dbi;
        this.jsonFactory = om.getJsonFactory();
        this.objectMapper = om;
        this.jsonSerializer = new JsonSerializer(this.objectMapper);
        this.restTemplate = new RestTemplate(dbi.getConnection());
        this.revisionHandler = new RevisionResponseHandler(this.objectMapper);
    }

    @Override
    public String path() {
        return this.dbPath.getPath();
    }

    public void setDatabaseName(String s) {
        this.dbPath = DbPath.fromString(s);
    }

    @Override
    public void create(final Object o) {
        Assert.notNull(o, "Document cannot be null");
        Assert.isTrue(ReflectionUtils.isNew(o), "Object must be new");
        StdResponseHandler<Void> rspHandler = new StdResponseHandler<Void>(){

            @Override
            public Void success(HttpResponse hr) throws Exception {
                OkDocOpRsp rsp = (OkDocOpRsp)StdCouchDbConnector.this.objectMapper.readValue(hr.getContent(), OkDocOpRsp.class);
                if (ReflectionUtils.getId(o) == null) {
                    ReflectionUtils.setId(o, rsp.id);
                }
                ReflectionUtils.setRevision(o, rsp.rev);
                return null;
            }
        };
        String json = this.jsonSerializer.toJson(o);
        String id = ReflectionUtils.getId(o);
        if (id != null) {
            if (this.contains(id)) {
                throw new DocumentExistsException(id);
            }
            this.restTemplate.put(this.dbPath.append(id), json, rspHandler);
        } else {
            this.restTemplate.post(this.dbPath.getPath(), json, rspHandler);
        }
    }

    @Override
    public void create(String id, JsonNode node) {
        this.assertDocIdHasValue(id);
        Assert.notNull(node, "Node cannot be null");
        this.restTemplate.put(this.dbPath.append(id), this.jsonSerializer.toJson(node));
    }

    @Override
    public boolean contains(String id) {
        return this.restTemplate.head(this.dbPath.append(id), new ResponseCallback<Boolean>(){

            @Override
            public Boolean error(HttpResponse hr) {
                if (hr.getCode() == 404) {
                    return Boolean.FALSE;
                }
                throw new DbAccessException(hr.toString());
            }

            @Override
            public Boolean success(HttpResponse hr) throws Exception {
                return Boolean.TRUE;
            }
        });
    }

    @Override
    public String createAttachment(String docId, Attachment a) {
        return this.createAttachment(docId, null, a);
    }

    @Override
    public String createAttachment(String docId, String revision, Attachment a) {
        this.assertDocIdHasValue(docId);
        String path = this.dbPath.append(docId) + "/" + a.getId();
        if (revision != null) {
            path = path + "?rev=" + revision;
        }
        return this.restTemplate.put(path, a.getData(), a.getContentType(), a.getLength(), this.revisionHandler);
    }

    @Override
    public Attachment getAttachment(String id, String attachmentId) {
        HttpResponse r;
        this.assertDocIdHasValue(id);
        Assert.hasText(attachmentId, "attachmentId must have a value");
        if (LOG.isTraceEnabled()) {
            LOG.trace("fetching attachment for doc: {} attachmentId: {}", (Object)id, (Object)attachmentId);
        }
        return (r = this.restTemplate.get(this.dbPath.append(id) + "/" + attachmentId)) != null ? new Attachment(attachmentId, r.getContent(), r.getContentType(), r.getContentLength()) : null;
    }

    @Override
    public String delete(Object o) {
        Assert.notNull(o, "document cannot be null");
        String rev = ReflectionUtils.getRevision(o);
        Object d = this.get(o.getClass(), rev);
        if (d != null) {
            return this.delete(ReflectionUtils.getId(o), rev);
        }
        return null;
    }

    @Override
    public <T> T get(final Class<T> c, String id) {
        Assert.notNull(c, "Class cannot be null");
        this.assertDocIdHasValue(id);
        return this.restTemplate.get(this.dbPath.append(id), new StdResponseHandler<T>(){

            @Override
            public T success(HttpResponse hr) throws Exception {
                return StdCouchDbConnector.this.objectMapper.readValue(hr.getContent(), c);
            }
        });
    }

    @Override
    public List<Revision> getRevisions(String id) {
        this.assertDocIdHasValue(id);
        return this.restTemplate.get(this.dbPath.append(id) + "?revs_info=true", new StdResponseHandler<List<Revision>>(){

            @Override
            public List<Revision> success(HttpResponse hr) throws Exception {
                JsonNode root = (JsonNode)StdCouchDbConnector.this.objectMapper.readValue(hr.getContent(), JsonNode.class);
                ArrayList<Revision> revs = new ArrayList<Revision>();
                Iterator i = root.get("_revs_info").getElements();
                while (i.hasNext()) {
                    JsonNode rev = (JsonNode)i.next();
                    revs.add(new Revision(rev.get("rev").getTextValue(), rev.get("status").getTextValue()));
                }
                return revs;
            }

            @Override
            public List<Revision> error(HttpResponse hr) {
                if (hr.getCode() == 404) {
                    return Collections.emptyList();
                }
                return (List)super.error(hr);
            }
        });
    }

    @Override
    public InputStream getAsStream(String id) {
        this.assertDocIdHasValue(id);
        HttpResponse r = this.restTemplate.get(this.dbPath.append(id));
        return r != null ? r.getContent() : null;
    }

    @Override
    public void update(final Object o) {
        Assert.notNull(o, "Document cannot be null");
        final String id = ReflectionUtils.getId(o);
        this.assertDocIdHasValue(id);
        this.restTemplate.put(this.dbPath.append(id), this.jsonSerializer.toJson(o), new StdResponseHandler<Void>(){

            @Override
            public Void success(HttpResponse hr) throws Exception {
                JsonNode n = (JsonNode)StdCouchDbConnector.this.objectMapper.readValue(hr.getContent(), JsonNode.class);
                ReflectionUtils.setRevision(o, n.get("rev").getTextValue());
                return null;
            }

            @Override
            public Void error(HttpResponse hr) {
                if (hr.getCode() == 409) {
                    throw new UpdateConflictException(id, ReflectionUtils.getId(o));
                }
                return (Void)super.error(hr);
            }
        });
    }

    @Override
    public String delete(String id, String revision) {
        this.assertDocIdHasValue(id);
        return this.restTemplate.delete(this.dbPath.append(id) + "?rev=" + revision, this.revisionHandler);
    }

    @Override
    public List<String> getAllDocIds() {
        return this.restTemplate.get(this.dbPath.getAllDocsPath(), new StdResponseHandler<List<String>>(){

            @Override
            public List<String> success(HttpResponse hr) throws Exception {
                JsonParser jp = StdCouchDbConnector.this.jsonFactory.createJsonParser(hr.getContent());
                if (jp.nextToken() != JsonToken.START_OBJECT) {
                    throw new RuntimeException("Expected data to start with an Object");
                }
                boolean inRow = false;
                ArrayList<String> result = null;
                while (jp.nextToken() != null) {
                    switch (jp.getCurrentToken()) {
                        case START_ARRAY: {
                            inRow = true;
                            break;
                        }
                        case END_ARRAY: {
                            inRow = false;
                            break;
                        }
                        case FIELD_NAME: {
                            String n = jp.getCurrentName();
                            if (inRow) {
                                if (!"id".equals(n)) break;
                                jp.nextToken();
                                result.add(jp.getText());
                                break;
                            }
                            if (!"total_rows".equals(n)) break;
                            jp.nextToken();
                            result = new ArrayList<String>(jp.getIntValue());
                        }
                    }
                }
                return result;
            }
        });
    }

    @Override
    public void createDatabaseIfNotExists() {
        if (!this.dbInstance.getAllDatabases().contains(this.dbPath.getDbName())) {
            this.dbInstance.createDatabase(this.dbPath);
        }
    }

    @Override
    public String getDatabaseName() {
        return this.dbPath.getDbName();
    }

    @Override
    public <T> List<T> queryView(ViewQuery query, final Class<T> type) {
        Assert.notNull(query, "query cannot be null");
        query.dbPath(this.dbPath.getPath());
        return (List)this.restTemplate.get(query.buildQuery(), new StdResponseHandler<List<T>>(){

            @Override
            public List<T> success(HttpResponse hr) throws Exception {
                JsonNode root = (JsonNode)StdCouchDbConnector.this.objectMapper.readValue(hr.getContent(), JsonNode.class);
                int totalRows = root.get("total_rows").getIntValue();
                ArrayList result = new ArrayList(totalRows);
                if (totalRows > 0) {
                    JsonNode rows = root.get("rows");
                    for (JsonNode row : rows) {
                        String id = row.get("value").getTextValue();
                        if (id == null || id.isEmpty()) {
                            throw new DbAccessException("view result value field did not contain a document id");
                        }
                        result.add(StdCouchDbConnector.this.get(type, id));
                    }
                }
                return result;
            }
        });
    }

    @Override
    public ViewResult queryView(ViewQuery query) {
        Assert.notNull(query, "query cannot be null");
        query.dbPath(this.dbPath.getPath());
        return this.restTemplate.get(query.buildQuery(), new StdResponseHandler<ViewResult>(){

            @Override
            public ViewResult success(HttpResponse hr) throws Exception {
                return (ViewResult)StdCouchDbConnector.this.objectMapper.readValue(hr.getContent(), ViewResult.class);
            }
        });
    }

    @Override
    public InputStream queryForStream(ViewQuery query) {
        Assert.notNull(query, "query cannot be null");
        query.dbPath(this.dbPath.getPath());
        return this.restTemplate.get(query.buildQuery()).getContent();
    }

    @Override
    public String deleteAttachment(String docId, String revision, String attachmentId) {
        return this.restTemplate.delete(this.dbPath.append(docId) + "/" + attachmentId + "?rev=" + revision, this.revisionHandler);
    }

    private void assertDocIdHasValue(String docId) {
        Assert.hasText(docId, "document id cannot be empty");
    }

    private static class OkDocOpRsp {
        public boolean ok;
        public String id;
        public String rev;

        private OkDocOpRsp() {
        }

        public void setOk(boolean ok) {
            this.ok = ok;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setRev(String rev) {
            this.rev = rev;
        }
    }
}

