/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.codehaus.jackson.annotate.JsonProperty;
import org.ektorp.InvalidDocumentException;
import org.ektorp.util.DocumentAccessor;
import org.ektorp.util.Exceptions;
import org.ektorp.util.Predicate;

public class ReflectionUtils {
    private static final ConcurrentMap<Class<?>, DocumentAccessor> accessors = new ConcurrentHashMap();

    public static String getId(Object document) {
        return ReflectionUtils.getAccessor(document).getId(document);
    }

    public static void setId(Object document, String id) {
        DocumentAccessor d = ReflectionUtils.getAccessor(document);
        if (d.hasIdMutator()) {
            d.setId(document, id);
        }
    }

    public static String getRevision(Object document) {
        return ReflectionUtils.getAccessor(document).getRevision(document);
    }

    public static void setRevision(Object document, String rev) {
        ReflectionUtils.getAccessor(document).setRevision(document, rev);
    }

    public static boolean isNew(Object document) {
        return ReflectionUtils.getRevision(document) == null;
    }

    private static DocumentAccessor getAccessor(Object document) {
        Class<?> clazz = document.getClass();
        DocumentAccessor accessor = (DocumentAccessor)accessors.get(clazz);
        if (accessor == null) {
            if (document instanceof Map) {
                accessor = (DocumentAccessor)accessors.get(Map.class);
                accessors.put(clazz, accessor);
            } else {
                accessors.putIfAbsent(clazz, new ReflectionAccessor(clazz));
                accessor = (DocumentAccessor)accessors.get(clazz);
            }
        }
        return accessor;
    }

    public static void eachAnnotatedMethod(Class<?> clazz, Class<? extends Annotation> annotationClass, Predicate<Method> p) {
        for (Method me : clazz.getDeclaredMethods()) {
            Annotation a = me.getAnnotation(annotationClass);
            if (a == null) continue;
            p.apply(me);
        }
        if (clazz.getSuperclass() != null) {
            ReflectionUtils.eachAnnotatedMethod(clazz.getSuperclass(), annotationClass, p);
        }
    }

    public static <T extends Annotation> void eachAnnotation(Class<?> clazz, Class<T> annotationClass, Predicate<T> p) {
        T a = clazz.getAnnotation(annotationClass);
        if (a != null) {
            p.apply(a);
        }
        for (Method me : clazz.getDeclaredMethods()) {
            a = me.getAnnotation(annotationClass);
            if (a == null) continue;
            p.apply(a);
        }
        if (clazz.getSuperclass() != null) {
            ReflectionUtils.eachAnnotation(clazz.getSuperclass(), annotationClass, p);
        }
    }

    public static List<Method> findAnnotatedMethods(Class<?> clazz, Class<? extends Annotation> annotationClass) {
        LinkedList<Method> result = new LinkedList<Method>();
        for (Method me : clazz.getDeclaredMethods()) {
            Annotation a = me.getAnnotation(annotationClass);
            if (a == null) continue;
            result.add(me);
        }
        if (clazz.getSuperclass() != null) {
            result.addAll(ReflectionUtils.findAnnotatedMethods(clazz.getSuperclass(), annotationClass));
        }
        return result;
    }

    public static Method findMethod(Class<?> clazz, String name) {
        for (Method me : clazz.getDeclaredMethods()) {
            if (!me.getName().equalsIgnoreCase(name)) continue;
            return me;
        }
        if (clazz.getSuperclass() != null) {
            return ReflectionUtils.findMethod(clazz.getSuperclass(), name);
        }
        return null;
    }

    static {
        accessors.put(Map.class, new MapAccessor());
    }

    private static final class MapAccessor
    implements DocumentAccessor {
        private static final String ID_FIELD_NAME = "_id";
        private static final String REV_FIELD_NAME = "_rev";

        private MapAccessor() {
        }

        @Override
        public String getId(Object o) {
            return this.cast(o).get(ID_FIELD_NAME);
        }

        @Override
        public String getRevision(Object o) {
            return this.cast(o).get(REV_FIELD_NAME);
        }

        @Override
        public boolean hasIdMutator() {
            return true;
        }

        @Override
        public void setId(Object o, String id) {
            this.cast(o).put(ID_FIELD_NAME, id);
        }

        @Override
        public void setRevision(Object o, String rev) {
            this.cast(o).put(REV_FIELD_NAME, rev);
        }

        private Map<String, String> cast(Object o) {
            return (Map)o;
        }
    }

    private static final class ReflectionAccessor
    implements DocumentAccessor {
        private final Class<?>[] NO_PARAMS = new Class[0];
        private final Object[] NO_ARGS = new Object[0];
        Method idAccessor;
        Method idMutator;
        Method revisionAccessor;
        Method revisionMutator;

        ReflectionAccessor(Class<?> clazz) {
            try {
                this.idAccessor = this.resolveIdAccessor(clazz);
                this.assertMethodFound(clazz, this.idAccessor, "id accessor");
                this.idMutator = this.resolveIdMutator(clazz);
                this.revisionAccessor = this.resolveRevAccessor(clazz);
                this.assertMethodFound(clazz, this.revisionAccessor, "revision accessor");
                this.revisionMutator = this.resolveRevMutator(clazz);
                this.assertMethodFound(clazz, this.revisionMutator, "revision mutator");
            }
            catch (InvalidDocumentException e) {
                throw e;
            }
            catch (Exception e) {
                throw Exceptions.propagate(e);
            }
        }

        @Override
        public boolean hasIdMutator() {
            return this.idMutator != null;
        }

        private void assertMethodFound(Class<?> clazz, Method m, String missingField) {
            if (m == null) {
                throw new InvalidDocumentException(clazz, missingField);
            }
        }

        private Method resolveRevAccessor(Class<?> clazz) throws Exception {
            Method m = null;
            m = this.findAnnotatedMethod(clazz, "_rev", "get");
            if (m == null) {
                m = this.findMethod(clazz, "getRevision", this.NO_PARAMS);
            }
            return m;
        }

        private Method resolveIdAccessor(Class<?> clazz) throws Exception {
            Method m = null;
            m = this.findAnnotatedMethod(clazz, "_id", "get");
            if (m == null) {
                m = this.findMethod(clazz, "getId", this.NO_PARAMS);
            }
            return m;
        }

        private Method findMethod(Class<?> clazz, String name, Class<?> ... parameters) throws Exception {
            for (Method me : clazz.getDeclaredMethods()) {
                if (!me.getName().equals(name) || me.getParameterTypes().length != parameters.length) continue;
                me.setAccessible(true);
                return me;
            }
            return clazz.getSuperclass() != null ? this.findMethod(clazz.getSuperclass(), name, parameters) : null;
        }

        private Method resolveIdMutator(Class<?> clazz) throws Exception {
            Method m = null;
            m = this.findAnnotatedMethod(clazz, "_id", "set");
            if (m == null) {
                m = this.findMethod(clazz, "setId", String.class);
            }
            return m;
        }

        private Method resolveRevMutator(Class<?> clazz) throws Exception {
            Method m = null;
            m = this.findAnnotatedMethod(clazz, "_rev", "set");
            if (m == null) {
                m = this.findMethod(clazz, "setRevision", String.class);
            }
            return m;
        }

        private Method findAnnotatedMethod(Class<?> clazz, String annotationValue, String methodPrefix) {
            for (Method me : clazz.getDeclaredMethods()) {
                JsonProperty a = me.getAnnotation(JsonProperty.class);
                if (a == null || !a.value().equals(annotationValue) || !me.getName().startsWith(methodPrefix)) continue;
                me.setAccessible(true);
                return me;
            }
            return clazz.getSuperclass() != null ? this.findAnnotatedMethod(clazz.getSuperclass(), annotationValue, methodPrefix) : null;
        }

        @Override
        public String getId(Object o) {
            try {
                return (String)this.idAccessor.invoke(o, this.NO_ARGS);
            }
            catch (Exception e) {
                throw Exceptions.propagate(e);
            }
        }

        @Override
        public void setId(Object o, String id) {
            try {
                this.idMutator.invoke(o, id);
            }
            catch (Exception e) {
                throw Exceptions.propagate(e);
            }
        }

        @Override
        public String getRevision(Object o) {
            try {
                return (String)this.revisionAccessor.invoke(o, this.NO_ARGS);
            }
            catch (Exception e) {
                throw Exceptions.propagate(e);
            }
        }

        @Override
        public void setRevision(Object o, String rev) {
            try {
                this.revisionMutator.invoke(o, rev);
            }
            catch (Exception e) {
                throw Exceptions.propagate(e);
            }
        }
    }

    public static interface AnnotationPredicate {
        public boolean equals(Method var1, Annotation var2);
    }
}

