package org.ektorp;

import java.io.*;
import java.util.*;

import org.codehaus.jackson.*;

/**
 * 
 * @author henrik lundgren
 *
 */
public class ViewResult implements Iterable<ViewResult.Row>, Serializable {

	private static final long serialVersionUID = 8028295884876096791L;
	private final int offset;
	private final List<Row> rows;
	
	public ViewResult(JsonNode root) {
		JsonNode offsetNode = root.get("offset");
		offset = offsetNode != null ? offsetNode.getIntValue() : 0;
		
		JsonNode totalRowsNode = root.get("total_rows"); 
        int totalRows = totalRowsNode != null ? totalRowsNode.getIntValue() : 10;
        rows = new ArrayList<ViewResult.Row>(totalRows);
        if (totalRows > 0) {
            JsonNode rowsNode = root.get("rows");
            for (JsonNode row : rowsNode) {
                readRow(row);
            }
        }
	}
	
	private void readRow(JsonNode row) {
		String key = nodeAsString(row.get("key"));
		String value = nodeAsString(row.get("value"));
		
		Row r = new Row(key, value);
		JsonNode idNode = row.get("id");
		if (idNode != null) {
			r.setId(idNode.getTextValue());
		}
		rows.add(r);
	}
	
	private String nodeAsString(JsonNode node) {
		return node.isContainerNode() ? node.toString() : node.getValueAsText();
	}
			
	public List<Row> getRows() {
		return rows;
	}
	
	public int getSize() {
		return rows.size();
	}
	
	public int getOffset() {
		return offset;
	}
	
	public boolean isEmpty() {
		return rows.isEmpty();
	}
	
	public Iterator<Row> iterator() {
		return getRows().iterator();
	}
	
	public static class Row implements Serializable {
		
		private static final long serialVersionUID = 76378730604602724L;
		private String id;
		private final String key;
		private final String value;
		
		public Row(String key, String value) {
			this.key = key;
			this.value = value;
		}
		
		public String getId() {
			return id;
		}
		
		public void setId(String s) {
			id = s;
		}
		
		public String getKey() {
			return key;
		}
		
		public String getValue() {
			return value;
		}
		
		public int getValueAsInt() {
			return Integer.parseInt(value);
		}
		
		@Override
		public boolean equals(Object o) {
			if (o == this) return true;
			if (o instanceof Row) {
				Row r = (Row)o;
				return id.equals(r.id) && key.equals(r.key) && value.equals(r.value);
			}
			return super.equals(o);
		}
		
		@Override
		public int hashCode() {
			return (id + key + value).hashCode();
		}
	}
	
}
