package org.ektorp.util;

import java.lang.annotation.*;
import java.lang.reflect.*;
import java.util.*;

public class ReflectionUtils {
	
	public static void eachAnnotatedMethod(Class<?> clazz, Class<? extends Annotation> annotationClass, Predicate<Method> p) {
		for (Method me : clazz.getDeclaredMethods()) {
			Annotation a = me.getAnnotation(annotationClass);
			if (a != null) {
				p.apply(me);
			}
		}
		
		if (clazz.getSuperclass() != null) {
			eachAnnotatedMethod(clazz.getSuperclass(), annotationClass, p);
		}
	}
	
	public static <T extends Annotation> void eachAnnotation(Class<?> clazz,
			Class<T> annotationClass, Predicate<T> p) {
		T a = clazz.getAnnotation(annotationClass);
		if (a != null) {
			p.apply(a);
		}
		for (Method me : clazz.getDeclaredMethods()) {
			a = me.getAnnotation(annotationClass);
			if (a != null) {
				p.apply(a);
			}
		}
		
		if (clazz.getSuperclass() != null) {
			eachAnnotation(clazz.getSuperclass(), annotationClass, p);
		}
		
	}
	
	public static List<Method> findAnnotatedMethods(Class<?> clazz, Class<? extends Annotation> annotationClass) {
		List<Method> result = new LinkedList<Method>();
		for (Method me : clazz.getDeclaredMethods()) {
			Annotation a = me.getAnnotation(annotationClass);
			if (a != null) {
				result.add(me);
			}
		}
		
		if (clazz.getSuperclass() != null) {
			result.addAll(findAnnotatedMethods(clazz.getSuperclass(), annotationClass));
		}
		return result;
	}
	/**
	 * Ignores case when comparing method names
	 * 
	 * @param clazz
	 * @param name
	 * @return
	 */
	public static Method findMethod(Class<?> clazz, String name) {
		for (Method me : clazz.getDeclaredMethods()) {
			if (me.getName().equalsIgnoreCase(name)) {
				return me;
			}
		}
		if (clazz.getSuperclass() != null) {
			return findMethod(clazz.getSuperclass(), name);
		}
		return null;
	}
	
	public interface AnnotationPredicate {
		boolean equals(Method m, Annotation a);
	}
}
