/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;
import org.ektorp.http.URI;
import org.ektorp.util.Exceptions;
import org.ektorp.util.JSONEncoding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewQuery {
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final String ALL_DOCS_VIEW_NAME = "_all_docs";
    private static final int NOT_SET = -1;
    private String dbPath;
    private String designDocId;
    private String viewName;
    private String key;
    private Keys keys;
    private String startKey;
    private String startDocId;
    private String endKey;
    private String endDocId;
    private int limit = -1;
    private boolean staleOk;
    private boolean descending;
    private int skip = -1;
    private boolean group;
    private int groupLevel = -1;
    private boolean reduce = true;
    private boolean includeDocs = false;
    private boolean inclusiveEnd = true;
    private String cachedQuery;
    private String listName;

    public String getDbPath() {
        return this.dbPath;
    }

    public String getDesignDocId() {
        return this.designDocId;
    }

    public String getViewName() {
        return this.viewName;
    }

    public String getStartDocId() {
        return this.startDocId;
    }

    public String getEndDocId() {
        return this.endDocId;
    }

    public int getLimit() {
        return this.limit;
    }

    public boolean isStaleOk() {
        return this.staleOk;
    }

    public boolean isDescending() {
        return this.descending;
    }

    public int getSkip() {
        return this.skip;
    }

    public boolean isGroup() {
        return this.group;
    }

    public int getGroupLevel() {
        return this.groupLevel;
    }

    public boolean isReduce() {
        return this.reduce;
    }

    public boolean isIncludeDocs() {
        return this.includeDocs;
    }

    public boolean isInclusiveEnd() {
        return this.inclusiveEnd;
    }

    public ViewQuery dbPath(String s) {
        this.reset();
        this.dbPath = s;
        return this;
    }

    public ViewQuery designDocId(String s) {
        this.reset();
        this.designDocId = s;
        return this;
    }

    public ViewQuery allDocs() {
        this.reset();
        this.viewName = ALL_DOCS_VIEW_NAME;
        return this;
    }

    public ViewQuery viewName(String s) {
        this.reset();
        this.viewName = s;
        return this;
    }

    public ViewQuery listName(String s) {
        this.reset();
        this.listName = s;
        return this;
    }

    public ViewQuery key(String s) {
        this.reset();
        this.key = JSONEncoding.jsonEncode(s);
        return this;
    }

    public ViewQuery key(int i) {
        this.reset();
        this.key = Integer.toString(i);
        return this;
    }

    public ViewQuery key(long l) {
        this.reset();
        this.key = Long.toString(l);
        return this;
    }

    public ViewQuery key(float f) {
        this.reset();
        this.key = Float.toString(f);
        return this;
    }

    public ViewQuery key(double d) {
        this.reset();
        this.key = Double.toString(d);
        return this;
    }

    public ViewQuery key(boolean b) {
        this.reset();
        this.key = Boolean.toString(b);
        return this;
    }

    public ViewQuery key(Object o) {
        this.reset();
        try {
            this.key = mapper.writeValueAsString(o);
        }
        catch (Exception e) {
            throw Exceptions.propagate(e);
        }
        return this;
    }

    public ViewQuery keys(Collection<Object> keyList) {
        this.reset();
        this.keys = Keys.of(keyList);
        return this;
    }

    public ViewQuery startKey(String s) {
        this.reset();
        this.startKey = JSONEncoding.jsonEncode(s);
        return this;
    }

    public ViewQuery startKey(int i) {
        this.reset();
        this.startKey = Integer.toString(i);
        return this;
    }

    public ViewQuery startKey(long l) {
        this.reset();
        this.startKey = Long.toString(l);
        return this;
    }

    public ViewQuery startKey(float f) {
        this.reset();
        this.startKey = Float.toString(f);
        return this;
    }

    public ViewQuery startKey(double d) {
        this.reset();
        this.startKey = Double.toString(d);
        return this;
    }

    public ViewQuery startKey(boolean b) {
        this.reset();
        this.startKey = Boolean.toString(b);
        return this;
    }

    public ViewQuery startKey(Object o) {
        this.reset();
        try {
            this.startKey = mapper.writeValueAsString(o);
        }
        catch (Exception e) {
            throw Exceptions.propagate(e);
        }
        return this;
    }

    public ViewQuery startDocId(String s) {
        this.reset();
        this.startDocId = s;
        return this;
    }

    public ViewQuery endKey(String s) {
        this.reset();
        this.endKey = JSONEncoding.jsonEncode(s);
        return this;
    }

    public ViewQuery endKey(int i) {
        this.reset();
        this.endKey = Integer.toString(i);
        return this;
    }

    public ViewQuery endKey(long l) {
        this.reset();
        this.endKey = Long.toString(l);
        return this;
    }

    public ViewQuery endKey(float f) {
        this.reset();
        this.endKey = Float.toString(f);
        return this;
    }

    public ViewQuery endKey(double d) {
        this.reset();
        this.endKey = Double.toString(d);
        return this;
    }

    public ViewQuery endKey(boolean b) {
        this.reset();
        this.endKey = Boolean.toString(b);
        return this;
    }

    public ViewQuery endKey(Object o) {
        this.reset();
        try {
            this.endKey = mapper.writeValueAsString(o);
        }
        catch (Exception e) {
            throw Exceptions.propagate(e);
        }
        return this;
    }

    public ViewQuery endDocId(String s) {
        this.reset();
        this.endDocId = s;
        return this;
    }

    public ViewQuery limit(int i) {
        this.reset();
        this.limit = i;
        return this;
    }

    public ViewQuery staleOk(boolean b) {
        this.reset();
        this.staleOk = b;
        return this;
    }

    public ViewQuery descending(boolean b) {
        this.reset();
        this.descending = b;
        return this;
    }

    public ViewQuery skip(int i) {
        this.reset();
        this.skip = i;
        return this;
    }

    public ViewQuery group(boolean b) {
        this.reset();
        this.group = b;
        return this;
    }

    public ViewQuery groupLevel(int i) {
        this.reset();
        this.groupLevel = i;
        return this;
    }

    public ViewQuery reduce(boolean b) {
        this.reset();
        this.reduce = b;
        return this;
    }

    public ViewQuery includeDocs(boolean b) {
        this.reset();
        this.includeDocs = b;
        return this;
    }

    public ViewQuery inclusiveEnd(boolean b) {
        this.reset();
        this.inclusiveEnd = b;
        return this;
    }

    public void reset() {
        this.cachedQuery = null;
    }

    public String getKey() {
        return this.key;
    }

    public boolean hasMultipleKeys() {
        return this.keys != null;
    }

    public String getKeysAsJson() {
        if (this.keys == null) {
            return "{\"keys\":[]}";
        }
        return this.keys.toJson();
    }

    public String getStartKey() {
        return this.startKey;
    }

    public String getEndKey() {
        return this.endKey;
    }

    public String buildQuery() {
        if (this.cachedQuery != null) {
            return this.cachedQuery;
        }
        URI query = this.buildViewPath();
        if (this.isNotEmpty(this.key)) {
            query.param("key", this.key);
        }
        if (this.isNotEmpty(this.startKey)) {
            query.param("startkey", this.startKey);
        }
        if (this.isNotEmpty(this.endKey)) {
            query.param("endkey", this.endKey);
        }
        if (this.isNotEmpty(this.startDocId)) {
            query.param("startkey_docid", this.startDocId);
        }
        if (this.isNotEmpty(this.endDocId)) {
            query.param("endkey_docid", this.endDocId);
        }
        if (this.hasValue(this.limit)) {
            query.param("limit", this.limit);
        }
        if (this.staleOk) {
            query.param("stale", "ok");
        }
        if (this.descending) {
            query.param("descending", "true");
        }
        if (!this.inclusiveEnd) {
            query.param("inclusive_end", "false");
        }
        if (!this.reduce) {
            query.param("reduce", "false");
        }
        if (this.hasValue(this.skip)) {
            query.param("skip", this.skip);
        }
        if (this.includeDocs) {
            query.param("include_docs", "true");
        }
        if (this.group) {
            query.param("group", "true");
        }
        if (this.hasValue(this.groupLevel)) {
            query.param("group_level", this.groupLevel);
        }
        this.cachedQuery = query.toString();
        return this.cachedQuery;
    }

    private URI buildViewPath() {
        this.assertHasText(this.dbPath, "dbPath");
        this.assertHasText(this.viewName, "viewName");
        URI uri = URI.of(this.dbPath);
        if (this.isNotEmpty(this.listName)) {
            uri.append(this.designDocId).append("_list").append(this.listName).append(this.viewName);
        } else if (ALL_DOCS_VIEW_NAME.equals(this.viewName)) {
            uri.append(this.viewName);
        } else {
            this.assertHasText(this.designDocId, "designDocId");
            uri.append(this.designDocId).append("_view").append(this.viewName);
        }
        return uri;
    }

    private void assertHasText(String s, String fieldName) {
        if (s == null || s.length() == 0) {
            throw new IllegalStateException(String.format("%s must have a value", fieldName));
        }
    }

    private boolean hasValue(int i) {
        return i != -1;
    }

    private boolean isNotEmpty(String s) {
        return s != null && s.length() > 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dbPath == null ? 0 : this.dbPath.hashCode());
        result = 31 * result + (this.descending ? 1231 : 1237);
        result = 31 * result + (this.designDocId == null ? 0 : this.designDocId.hashCode());
        result = 31 * result + (this.endDocId == null ? 0 : this.endDocId.hashCode());
        result = 31 * result + (this.endKey == null ? 0 : this.endKey.hashCode());
        result = 31 * result + (this.group ? 1231 : 1237);
        result = 31 * result + this.groupLevel;
        result = 31 * result + (this.includeDocs ? 1231 : 1237);
        result = 31 * result + (this.inclusiveEnd ? 1231 : 1237);
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + this.limit;
        result = 31 * result + (this.reduce ? 1231 : 1237);
        result = 31 * result + this.skip;
        result = 31 * result + (this.staleOk ? 1231 : 1237);
        result = 31 * result + (this.startDocId == null ? 0 : this.startDocId.hashCode());
        result = 31 * result + (this.startKey == null ? 0 : this.startKey.hashCode());
        result = 31 * result + (this.viewName == null ? 0 : this.viewName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ViewQuery other = (ViewQuery)obj;
        if (this.dbPath == null ? other.dbPath != null : !this.dbPath.equals(other.dbPath)) {
            return false;
        }
        if (this.descending != other.descending) {
            return false;
        }
        if (this.designDocId == null ? other.designDocId != null : !this.designDocId.equals(other.designDocId)) {
            return false;
        }
        if (this.endDocId == null ? other.endDocId != null : !this.endDocId.equals(other.endDocId)) {
            return false;
        }
        if (this.endKey == null ? other.endKey != null : !this.endKey.equals(other.endKey)) {
            return false;
        }
        if (this.group != other.group) {
            return false;
        }
        if (this.groupLevel != other.groupLevel) {
            return false;
        }
        if (this.includeDocs != other.includeDocs) {
            return false;
        }
        if (this.inclusiveEnd != other.inclusiveEnd) {
            return false;
        }
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        if (this.limit != other.limit) {
            return false;
        }
        if (this.reduce != other.reduce) {
            return false;
        }
        if (this.skip != other.skip) {
            return false;
        }
        if (this.staleOk != other.staleOk) {
            return false;
        }
        if (this.startDocId == null ? other.startDocId != null : !this.startDocId.equals(other.startDocId)) {
            return false;
        }
        if (this.startKey == null ? other.startKey != null : !this.startKey.equals(other.startKey)) {
            return false;
        }
        return !(this.viewName == null ? other.viewName != null : !this.viewName.equals(other.viewName));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Keys {
        private final List<Object> keys;

        public static Keys of(Collection<Object> keys) {
            return new Keys(keys);
        }

        public static Keys of(Object ... keys) {
            return new Keys(keys);
        }

        private Keys(Collection<Object> keys) {
            this.keys = new ArrayList<Object>(keys);
        }

        private Keys(Object[] keys) {
            this.keys = Arrays.asList(keys);
        }

        public String toJson() {
            ObjectNode rootNode = mapper.createObjectNode();
            ArrayNode keysNode = rootNode.putArray("keys");
            for (Object key : this.keys) {
                keysNode.addPOJO(key);
            }
            try {
                return mapper.writeValueAsString((Object)rootNode);
            }
            catch (Exception e) {
                throw Exceptions.propagate(e);
            }
        }
    }
}

