/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.jackson.JsonNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewResult
implements Iterable<Row>,
Serializable {
    private static final long serialVersionUID = 8028295884876096791L;
    private final int offset;
    private final List<Row> rows;

    public ViewResult(JsonNode root) {
        JsonNode offsetNode = root.get("offset");
        this.offset = offsetNode != null ? offsetNode.getIntValue() : 0;
        JsonNode totalRowsNode = root.get("total_rows");
        int totalRows = totalRowsNode != null ? totalRowsNode.getIntValue() : 10;
        this.rows = new ArrayList<Row>(totalRows);
        if (totalRows > 0) {
            JsonNode rowsNode = root.get("rows");
            for (JsonNode row : rowsNode) {
                this.readRow(row);
            }
        }
    }

    private void readRow(JsonNode row) {
        String key = this.nodeAsString(row.get("key"));
        String value = this.nodeAsString(row.get("value"));
        Row r = new Row(key, value);
        JsonNode idNode = row.get("id");
        if (idNode != null) {
            r.setId(idNode.getTextValue());
        }
        this.rows.add(r);
    }

    private String nodeAsString(JsonNode node) {
        return node.isContainerNode() ? node.toString() : node.getValueAsText();
    }

    public List<Row> getRows() {
        return this.rows;
    }

    public int getSize() {
        return this.rows.size();
    }

    public int getOffset() {
        return this.offset;
    }

    public boolean isEmpty() {
        return this.rows.isEmpty();
    }

    @Override
    public Iterator<Row> iterator() {
        return this.getRows().iterator();
    }

    public static class Row
    implements Serializable {
        private static final long serialVersionUID = 76378730604602724L;
        private String id;
        private final String key;
        private final String value;

        public Row(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String s) {
            this.id = s;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public int getValueAsInt() {
            return Integer.parseInt(this.value);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Row) {
                Row r = (Row)o;
                return this.id.equals(r.id) && this.key.equals(r.key) && this.value.equals(r.value);
            }
            return super.equals(o);
        }

        public int hashCode() {
            return (this.id + this.key + this.value).hashCode();
        }
    }
}

