/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.http;

import java.io.InputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.params.ConnPerRoute;
import org.apache.http.conn.params.ConnPerRouteBean;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.ektorp.http.HttpClient;
import org.ektorp.http.HttpResponse;
import org.ektorp.http.StdHttpResponse;
import org.ektorp.util.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StdHttpClient
implements HttpClient {
    private final org.apache.http.client.HttpClient client;
    private static final Logger LOG = LoggerFactory.getLogger(StdHttpClient.class);

    public StdHttpClient(org.apache.http.client.HttpClient hc) {
        this.client = hc;
    }

    public HttpResponse delete(String uri) {
        return this.executeRequest((HttpRequestBase)new HttpDelete(uri));
    }

    public HttpResponse get(String uri) {
        return this.executeRequest((HttpRequestBase)new HttpGet(uri));
    }

    public HttpResponse post(String uri, String content) {
        return this.executePutPost((HttpEntityEnclosingRequestBase)new HttpPost(uri), content);
    }

    public HttpResponse post(String uri, InputStream content) {
        InputStreamEntity e = new InputStreamEntity(content, -1L);
        e.setContentType("application/json");
        HttpPost post = new HttpPost(uri);
        post.setEntity((HttpEntity)e);
        return this.executeRequest((HttpRequestBase)post);
    }

    public HttpResponse put(String uri, String content) {
        return this.executePutPost((HttpEntityEnclosingRequestBase)new HttpPut(uri), content);
    }

    public HttpResponse put(String uri) {
        return this.executeRequest((HttpRequestBase)new HttpPut(uri));
    }

    public HttpResponse put(String uri, InputStream data, String contentType, long contentLength) {
        InputStreamEntity e = new InputStreamEntity(data, contentLength);
        e.setContentType(contentType);
        HttpPut hp = new HttpPut(uri);
        hp.setEntity((HttpEntity)e);
        return this.executeRequest((HttpRequestBase)hp);
    }

    public HttpResponse head(String uri) {
        return this.executeRequest((HttpRequestBase)new HttpHead(uri));
    }

    private HttpResponse executePutPost(HttpEntityEnclosingRequestBase request, String content) {
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Content: {}", (Object)content);
            }
            StringEntity e = new StringEntity(content, "UTF-8");
            e.setContentType("application/json");
            request.setEntity((HttpEntity)e);
            return this.executeRequest((HttpRequestBase)request);
        }
        catch (Exception e) {
            throw Exceptions.propagate(e);
        }
    }

    private HttpResponse executeRequest(HttpRequestBase request) {
        try {
            org.apache.http.HttpResponse rsp = this.client.execute((HttpUriRequest)request);
            if (LOG.isTraceEnabled()) {
                LOG.trace(String.format("%s %s %s", request.getMethod(), request.getURI(), rsp.getStatusLine().getStatusCode(), rsp.getStatusLine().getReasonPhrase()));
            }
            return StdHttpResponse.of(rsp, request.getURI().toString());
        }
        catch (Exception e) {
            throw Exceptions.propagate(e);
        }
    }

    public static class Builder {
        String host = "localhost";
        int port = 5984;
        int maxConnections = 20;
        int connectionTimeout = 1000;
        int socketTimeout = 10000;
        ClientConnectionManager conman;
        String username;
        String password;

        public Builder host(String s) {
            this.host = s;
            return this;
        }

        public ClientConnectionManager configureConnectionManager() {
            if (this.conman != null) {
                return this.conman;
            }
            SchemeRegistry schemeRegistry = new SchemeRegistry();
            schemeRegistry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), this.port));
            BasicHttpParams params = new BasicHttpParams();
            HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)this.connectionTimeout);
            HttpConnectionParams.setSoTimeout((HttpParams)params, (int)this.socketTimeout);
            HttpConnectionParams.setTcpNoDelay((HttpParams)params, (boolean)Boolean.TRUE);
            ConnManagerParams.setMaxTotalConnections((HttpParams)params, (int)this.maxConnections);
            ConnManagerParams.setMaxConnectionsPerRoute((HttpParams)params, (ConnPerRoute)new ConnPerRouteBean(this.maxConnections));
            return new ThreadSafeClientConnManager((HttpParams)params, schemeRegistry);
        }

        public org.apache.http.client.HttpClient configureClient() {
            BasicHttpParams params = new BasicHttpParams();
            params.setParameter("http.default-host", (Object)new HttpHost(this.host, this.port, "http"));
            DefaultHttpClient dc = new DefaultHttpClient(this.configureConnectionManager(), (HttpParams)params);
            if (this.username != null && this.password != null) {
                dc.getCredentialsProvider().setCredentials(new AuthScope(this.host, this.port), (Credentials)new UsernamePasswordCredentials(this.username, this.password));
            }
            return dc;
        }

        public Builder port(int i) {
            this.port = i;
            return this;
        }

        public Builder username(String s) {
            this.username = s;
            return this;
        }

        public Builder password(String s) {
            this.password = s;
            return this;
        }

        public Builder maxConnections(int i) {
            this.maxConnections = i;
            return this;
        }

        public Builder connectionTimeout(int i) {
            this.connectionTimeout = i;
            return this;
        }

        public Builder socketTimeout(int i) {
            this.socketTimeout = i;
            return this;
        }

        public Builder connectionManager(ClientConnectionManager cm) {
            this.conman = cm;
            return this;
        }

        public HttpClient build() {
            return new StdHttpClient(this.configureClient());
        }
    }
}

