/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.http;

import org.ektorp.DbAccessException;
import org.ektorp.DocumentNotFoundException;
import org.ektorp.UpdateConflictException;
import org.ektorp.http.HttpResponse;
import org.ektorp.http.ResponseCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StdResponseHandler<T>
implements ResponseCallback<T> {
    public static DbAccessException createDbAccessException(HttpResponse hr) {
        switch (hr.getCode()) {
            case 404: {
                return new DocumentNotFoundException(hr.getRequestURI());
            }
            case 409: {
                return new UpdateConflictException();
            }
        }
        return new DbAccessException(hr.toString() + ", URI: " + hr.getRequestURI());
    }

    @Override
    public T error(HttpResponse hr) {
        throw StdResponseHandler.createDbAccessException(hr);
    }

    @Override
    public T success(HttpResponse hr) throws Exception {
        return null;
    }
}

