/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.ObjectMapper;
import org.ektorp.http.HttpResponse;
import org.ektorp.http.StdResponseHandler;
import org.ektorp.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmbeddedDocViewResponseHandler<T>
extends StdResponseHandler<List<T>> {
    private static final String ROWS_FIELD_NAME = "rows";
    private static final String VALUE_FIELD_NAME = "value";
    private static final String INCLUDED_DOC_FIELD_NAME = "doc";
    private static final String TOTAL_ROWS_FIELD_NAME = "total_rows";
    private final ObjectMapper mapper;
    private final Class<T> type;

    public EmbeddedDocViewResponseHandler(Class<T> docType, ObjectMapper om) {
        Assert.notNull(om, "ObjectMapper may not be null");
        Assert.notNull(docType, "docType may not be null");
        this.mapper = om;
        this.type = docType;
    }

    @Override
    public List<T> success(HttpResponse hr) throws Exception {
        JsonParser jp = this.mapper.getJsonFactory().createJsonParser(hr.getContent());
        if (jp.nextToken() != JsonToken.START_OBJECT) {
            throw new RuntimeException("Expected data to start with an Object");
        }
        Map<String, Integer> fields = this.readHeaderFields(jp);
        ArrayList<Object> result = fields.containsKey(TOTAL_ROWS_FIELD_NAME) ? new ArrayList(fields.get(TOTAL_ROWS_FIELD_NAME)) : new ArrayList<Object>();
        while (jp.nextToken() != null) {
            this.skipToDoc(jp);
            if (jp.getCurrentToken() != JsonToken.START_OBJECT) break;
            result.add(jp.readValueAs(this.type));
        }
        return result;
    }

    private void skipToDoc(JsonParser jp) throws JsonParseException, IOException {
        while (jp.nextToken() != null) {
            JsonToken token = jp.getCurrentToken();
            if (token != JsonToken.FIELD_NAME) continue;
            String nextFieldName = jp.getCurrentName();
            token = jp.nextToken();
            if (!nextFieldName.equals(VALUE_FIELD_NAME) && !nextFieldName.equals(INCLUDED_DOC_FIELD_NAME) || token != JsonToken.START_OBJECT) continue;
            break;
        }
    }

    private Map<String, Integer> readHeaderFields(JsonParser jp) throws JsonParseException, IOException {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        jp.nextToken();
        String nextFieldName = jp.getCurrentName();
        while (!nextFieldName.equals(ROWS_FIELD_NAME)) {
            jp.nextToken();
            map.put(nextFieldName, jp.getIntValue());
            jp.nextToken();
            nextFieldName = jp.getCurrentName();
        }
        return map;
    }
}

