/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.ektorp.DbAccessException;
import org.ektorp.http.HttpResponse;
import org.ektorp.http.StdResponseHandler;
import org.ektorp.impl.StdCouchDbConnector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryViewResponseHandler<T>
extends StdResponseHandler<List<T>> {
    private final ObjectMapper objectMapper;
    private final boolean includeDocs;
    private final Class<T> type;
    private final StdCouchDbConnector db;
    private List<T> result;

    public static <T> QueryViewResponseHandler<T> newDocsIncludedHandler(ObjectMapper objectMapper, Class<T> type) {
        return new QueryViewResponseHandler<T>(objectMapper, true, type, null);
    }

    public static <T> QueryViewResponseHandler<T> newLoadDocsByIdHandler(ObjectMapper objectMapper, Class<T> type, StdCouchDbConnector db) {
        return new QueryViewResponseHandler<T>(objectMapper, false, type, db);
    }

    private QueryViewResponseHandler(ObjectMapper objectMapper, boolean includeDocs, Class<T> type, StdCouchDbConnector db) {
        this.objectMapper = objectMapper;
        this.includeDocs = includeDocs;
        this.type = type;
        this.db = db;
    }

    @Override
    public List<T> success(HttpResponse hr) throws Exception {
        this.assertInstanceIsFresh();
        JsonNode root = (JsonNode)this.objectMapper.readValue(hr.getContent(), JsonNode.class);
        JsonNode totalRowsNode = root.get("total_rows");
        int totalRows = totalRowsNode != null ? totalRowsNode.getIntValue() : 10;
        this.result = new ArrayList<T>(totalRows);
        if (totalRows > 0) {
            JsonNode rows = root.get("rows");
            for (JsonNode row : rows) {
                this.readRow(row);
            }
        }
        return this.result;
    }

    private void assertInstanceIsFresh() {
        if (this.result != null) {
            throw new IllegalStateException("This response handler has already been used once.");
        }
    }

    private void readRow(JsonNode row) throws IOException, JsonParseException, JsonMappingException {
        if (this.includeDocs) {
            this.readIncludedDoc(row);
        } else {
            JsonNode jsonValue = row.get("value");
            if (jsonValue.isTextual()) {
                this.readDocFromDb(row);
            } else {
                this.readEmbeddedDoc(jsonValue);
            }
        }
    }

    private void readDocFromDb(JsonNode row) {
        String id = row.get("value").getTextValue();
        if (id == null || id.length() == 0) {
            throw new DbAccessException("view result value field did not contain a document id");
        }
        this.result.add(this.db.get(this.type, id));
    }

    private void readEmbeddedDoc(JsonNode jsonValue) throws IOException, JsonParseException, JsonMappingException {
        this.result.add(this.objectMapper.treeToValue(jsonValue, this.type));
    }

    private void readIncludedDoc(JsonNode row) throws IOException, JsonParseException, JsonMappingException {
        JsonNode doc = row.get("doc");
        this.readEmbeddedDoc(doc);
    }

    public List<T> getResult() {
        return this.result;
    }
}

