/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.support;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.ektorp.ComplexKey;
import org.ektorp.CouchDbConnector;
import org.ektorp.ViewQuery;
import org.ektorp.support.DesignDocument;
import org.ektorp.support.GenericRepository;
import org.ektorp.support.SimpleViewGenerator;
import org.ektorp.util.Assert;
import org.ektorp.util.Documents;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CouchDbRepositorySupport<T>
implements GenericRepository<T> {
    public static final String AUTO_UPDATE_VIEW_ON_CHANGE = "org.ektorp.support.AutoUpdateViewOnChange";
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final CouchDbConnector db;
    private final Class<T> type;
    private final String stdDesignDocumentId;
    private Boolean autoUpdateViewOnChange;

    protected CouchDbRepositorySupport(Class<T> type, CouchDbConnector db) {
        Assert.notNull(db, "CouchDbConnector may not be null");
        Assert.notNull(type);
        this.db = db;
        this.type = type;
        db.createDatabaseIfNotExists();
        this.stdDesignDocumentId = DesignDocument.ID_PREFIX + type.getSimpleName();
    }

    @Override
    public void add(T entity) {
        this.assertEntityNotNull(entity);
        Assert.isTrue(Documents.isNew(entity), "entity must be new");
        this.db.create(entity);
    }

    @Override
    public List<T> getAll() {
        if (this.designDocContainsAllView()) {
            return this.queryView("all");
        }
        return this.loadAllByAllDocIds();
    }

    private boolean designDocContainsAllView() {
        if (this.db.contains(this.stdDesignDocumentId)) {
            DesignDocument dd = this.db.get(DesignDocument.class, this.stdDesignDocumentId);
            return dd.containsView("all");
        }
        return false;
    }

    private List<T> loadAllByAllDocIds() {
        List<String> ids = this.db.getAllDocIds();
        ArrayList<T> all = new ArrayList<T>(ids.size());
        for (String id : ids) {
            if (id.startsWith("_design")) continue;
            all.add(this.get(id));
        }
        return all;
    }

    @Override
    public T get(String id) {
        return this.db.get(this.type, id);
    }

    @Override
    public T get(String id, String rev) {
        return this.db.get(this.type, id, rev);
    }

    @Override
    public void remove(T entity) {
        this.assertEntityNotNull(entity);
        this.db.delete(Documents.getId(entity), Documents.getRevision(entity));
    }

    @Override
    public void update(T entity) {
        this.assertEntityNotNull(entity);
        this.db.update(entity);
    }

    private void assertEntityNotNull(T entity) {
        Assert.notNull(entity, "entity may not be null");
    }

    protected ViewQuery createQuery(String viewName) {
        return new ViewQuery().dbPath(this.db.path()).designDocId(this.stdDesignDocumentId).viewName(viewName);
    }

    protected List<T> queryView(String viewName, String key) {
        return this.db.queryView(this.createQuery(viewName).includeDocs(true).key(key), this.type);
    }

    protected List<T> queryView(String viewName, int key) {
        return this.db.queryView(this.createQuery(viewName).includeDocs(true).key(key), this.type);
    }

    protected List<T> queryView(String viewName, ComplexKey key) {
        return this.db.queryView(this.createQuery(viewName).includeDocs(true).key(key), this.type);
    }

    protected List<T> queryView(String viewName) {
        return this.db.queryView(this.createQuery(viewName).includeDocs(true), this.type);
    }

    public void initStandardDesignDocument() {
        String id = DesignDocument.ID_PREFIX + this.type.getSimpleName();
        DesignDocument designDoc = this.db.contains(id) ? this.db.get(DesignDocument.class, id) : new DesignDocument(id);
        if (this.generateViews(designDoc)) {
            this.db.update(designDoc);
        }
    }

    private boolean generateViews(DesignDocument designDoc) {
        Map<String, DesignDocument.View> generated = new SimpleViewGenerator().generateViews(this);
        boolean changed = false;
        for (Map.Entry<String, DesignDocument.View> e : generated.entrySet()) {
            DesignDocument.View existing;
            String name = e.getKey();
            DesignDocument.View candidate = e.getValue();
            if (!designDoc.containsView(name)) {
                designDoc.addView(name, candidate);
                changed = true;
                continue;
            }
            if (!this.updateViewWhenChanged() || (existing = designDoc.get(name)).equals(candidate)) continue;
            designDoc.addView(name, candidate);
            changed = true;
        }
        return changed;
    }

    private boolean updateViewWhenChanged() {
        if (this.autoUpdateViewOnChange == null) {
            this.autoUpdateViewOnChange = Boolean.getBoolean(AUTO_UPDATE_VIEW_ON_CHANGE);
        }
        return this.autoUpdateViewOnChange;
    }

    @Override
    public boolean contains(String docId) {
        return this.db.contains(docId);
    }

    Class<?> getHandledType() {
        return this.type;
    }
}

