/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.util;

import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Assert {
    private Assert() {
    }

    public static void notNull(Object o) {
        Assert.notNull(o, null);
    }

    public static void notNull(Object o, String message) {
        if (o == null) {
            throw message == null ? new NullPointerException() : new NullPointerException(message);
        }
    }

    public static void isNull(Object o, String message) {
        if (o != null) {
            Assert.throwIllegalArgument(message);
        }
    }

    public static void isTrue(boolean b) {
        Assert.isTrue(b, null);
    }

    public static void isTrue(boolean b, String message) {
        if (!b) {
            Assert.throwIllegalArgument(message);
        }
    }

    public static void notEmpty(Collection<?> c, String message) {
        Assert.notNull(c, message);
        if (c.isEmpty()) {
            Assert.throwIllegalArgument(message);
        }
    }

    public static void notEmpty(Object[] a, String message) {
        Assert.notNull(a, message);
        if (a.length == 0) {
            Assert.throwIllegalArgument(message);
        }
    }

    public static void hasText(String s) {
        Assert.hasText(s, null);
    }

    public static void hasText(String s, String message) {
        if (s == null || s.length() == 0) {
            Assert.throwIllegalArgument(message);
        }
    }

    private static void throwIllegalArgument(String s) {
        throw s == null ? new IllegalArgumentException() : new IllegalArgumentException(s);
    }
}

