package org.ektorp.http;

import java.io.*;

import org.apache.commons.io.*;
import org.ektorp.*;

/**
 * 
 * @author henrik lundgren
 *
 * @param <T>
 */
public class StdResponseHandler<T> implements ResponseCallback<T> {
	/**
	 * Creates an DbAccessException which specific type is determined by the response code in the http response.
	 * @param hr
	 * @return
	 */
	public static DbAccessException createDbAccessException(HttpResponse hr) {
		switch (hr.getCode()) {
		case HttpStatus.NOT_FOUND:
			return new DocumentNotFoundException(hr.getRequestURI());
		case HttpStatus.CONFLICT:
			return new UpdateConflictException();
		default:
			String body = "Unvailable";
			try {
				body = IOUtils.toString(hr.getContent());
			} catch (IOException e) {
				// ignore
			}
			return new DbAccessException(hr.toString() + ", URI: " + hr.getRequestURI() + " response body: " + body);
		}
	}
	
	public T error(HttpResponse hr) {
		throw StdResponseHandler.createDbAccessException(hr);
	}
	
	public T success(HttpResponse hr) throws Exception {
		return null;
	}

}
