/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.http;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.ektorp.DbAccessException;
import org.ektorp.DocumentNotFoundException;
import org.ektorp.UpdateConflictException;
import org.ektorp.http.HttpResponse;
import org.ektorp.http.ResponseCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StdResponseHandler<T>
implements ResponseCallback<T> {
    public static DbAccessException createDbAccessException(HttpResponse hr) {
        switch (hr.getCode()) {
            case 404: {
                return new DocumentNotFoundException(hr.getRequestURI());
            }
            case 409: {
                return new UpdateConflictException();
            }
        }
        String body = "Unvailable";
        try {
            body = IOUtils.toString((InputStream)hr.getContent());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new DbAccessException(hr.toString() + ", URI: " + hr.getRequestURI() + " response body: " + body);
    }

    @Override
    public T error(HttpResponse hr) {
        throw StdResponseHandler.createDbAccessException(hr);
    }

    @Override
    public T success(HttpResponse hr) throws Exception {
        return null;
    }
}

