/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.impl;

import java.io.InputStream;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.ektorp.util.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BulkOperation {
    private final Logger LOG = LoggerFactory.getLogger(BulkOperation.class);
    private final InputStream data;
    private final Future<?> writeTask;

    public BulkOperation(Future<?> writeTask, InputStream data) {
        this.data = data;
        this.writeTask = writeTask;
    }

    public InputStream getData() {
        return this.data;
    }

    public void awaitCompletion() {
        try {
            this.writeTask.get();
        }
        catch (InterruptedException e) {
            this.LOG.info("BulkOperation was interrupted while waiting on write task to complete.");
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            throw Exceptions.propagate(e.getCause());
        }
    }
}

