/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.ektorp.ViewResultException;
import org.ektorp.http.HttpResponse;
import org.ektorp.http.StdResponseHandler;
import org.ektorp.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmbeddedDocViewResponseHandler<T>
extends StdResponseHandler<List<T>> {
    private static final String ROWS_FIELD_NAME = "rows";
    private static final String VALUE_FIELD_NAME = "value";
    private static final String INCLUDED_DOC_FIELD_NAME = "doc";
    private static final String TOTAL_ROWS_FIELD_NAME = "total_rows";
    private final ObjectMapper mapper;
    private final Class<T> type;

    public EmbeddedDocViewResponseHandler(Class<T> docType, ObjectMapper om) {
        Assert.notNull(om, "ObjectMapper may not be null");
        Assert.notNull(docType, "docType may not be null");
        this.mapper = om;
        this.type = docType;
    }

    @Override
    public List<T> success(HttpResponse hr) throws Exception {
        ArrayList<Object> result;
        JsonParser jp = this.mapper.getJsonFactory().createJsonParser(hr.getContent());
        if (jp.nextToken() != JsonToken.START_OBJECT) {
            throw new RuntimeException("Expected data to start with an Object");
        }
        Map<String, Integer> fields = this.readHeaderFields(jp);
        if (fields.containsKey(TOTAL_ROWS_FIELD_NAME)) {
            int totalRows = fields.get(TOTAL_ROWS_FIELD_NAME);
            if (totalRows == 0) {
                return Collections.emptyList();
            }
            result = new ArrayList(totalRows);
        } else {
            result = new ArrayList<Object>();
        }
        ParseState state = new ParseState();
        T first = this.parseFirstRow(jp, state);
        if (first == null) {
            return Collections.emptyList();
        }
        result.add(first);
        while (jp.getCurrentToken() != null) {
            this.skipToField(jp, state.docFieldName, state);
            if (this.atEndOfRows(jp)) {
                return result;
            }
            result.add(jp.readValueAs(this.type));
            this.endRow(jp, state);
        }
        return result;
    }

    private T parseFirstRow(JsonParser jp, ParseState state) throws JsonParseException, IOException, JsonProcessingException, JsonMappingException {
        this.skipToField(jp, VALUE_FIELD_NAME, state);
        JsonNode value = null;
        if (this.atObjectStart(jp)) {
            value = jp.readValueAsTree();
            jp.nextToken();
            if (this.isEndOfRow(jp)) {
                state.docFieldName = VALUE_FIELD_NAME;
                Object doc = this.mapper.readValue(value, this.type);
                this.endRow(jp, state);
                return (T)doc;
            }
        }
        this.skipToField(jp, INCLUDED_DOC_FIELD_NAME, state);
        if (this.atObjectStart(jp)) {
            state.docFieldName = INCLUDED_DOC_FIELD_NAME;
            Object doc = jp.readValueAs(this.type);
            this.endRow(jp, state);
            return (T)doc;
        }
        return null;
    }

    private boolean isEndOfRow(JsonParser jp) {
        return jp.getCurrentToken() == JsonToken.END_OBJECT;
    }

    private void endRow(JsonParser jp, ParseState state) throws IOException, JsonParseException {
        state.inRow = false;
        jp.nextToken();
    }

    private boolean atObjectStart(JsonParser jp) {
        return jp.getCurrentToken() == JsonToken.START_OBJECT;
    }

    private boolean atEndOfRows(JsonParser jp) {
        return jp.getCurrentToken() != JsonToken.START_OBJECT;
    }

    private void skipToField(JsonParser jp, String fieldName, ParseState state) throws JsonParseException, IOException {
        String lastFieldName = null;
        block4: while (jp.getCurrentToken() != null) {
            switch (jp.getCurrentToken()) {
                case FIELD_NAME: {
                    lastFieldName = jp.getCurrentName();
                    jp.nextToken();
                    continue block4;
                }
                case START_OBJECT: {
                    if (!state.inRow) {
                        state.inRow = true;
                        jp.nextToken();
                        continue block4;
                    }
                    if (this.isInField(fieldName, lastFieldName)) {
                        return;
                    }
                    jp.skipChildren();
                    continue block4;
                }
            }
            if (this.isInField("key", lastFieldName)) {
                state.lastKey = jp.readValueAsTree();
            } else {
                if (this.isInField("error", lastFieldName)) {
                    JsonNode error = jp.readValueAsTree();
                    throw new ViewResultException(state.lastKey, error.getValueAsText());
                }
                if (this.isInField(fieldName, lastFieldName)) {
                    jp.nextToken();
                    return;
                }
            }
            jp.nextToken();
        }
    }

    private boolean isInField(String fieldName, String lastFieldName) {
        return lastFieldName != null && lastFieldName.equals(fieldName);
    }

    private Map<String, Integer> readHeaderFields(JsonParser jp) throws JsonParseException, IOException {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        jp.nextToken();
        String nextFieldName = jp.getCurrentName();
        while (!nextFieldName.equals(ROWS_FIELD_NAME)) {
            jp.nextToken();
            map.put(nextFieldName, jp.getIntValue());
            jp.nextToken();
            nextFieldName = jp.getCurrentName();
        }
        return map;
    }

    private static class ParseState {
        boolean inRow;
        JsonNode lastKey;
        String docFieldName = "";

        private ParseState() {
        }
    }
}

