/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.impl;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.ektorp.AttachmentInputStream;
import org.ektorp.CouchDbConnector;
import org.ektorp.CouchDbInstance;
import org.ektorp.DbAccessException;
import org.ektorp.DbInfo;
import org.ektorp.DbPath;
import org.ektorp.DocumentExistsException;
import org.ektorp.DocumentOperationResult;
import org.ektorp.ReplicationCommand;
import org.ektorp.ReplicationStatus;
import org.ektorp.Revision;
import org.ektorp.UpdateConflictException;
import org.ektorp.ViewQuery;
import org.ektorp.ViewResult;
import org.ektorp.http.HttpClient;
import org.ektorp.http.HttpResponse;
import org.ektorp.http.ResponseCallback;
import org.ektorp.http.RestTemplate;
import org.ektorp.http.StdResponseHandler;
import org.ektorp.http.URI;
import org.ektorp.impl.BulkOperation;
import org.ektorp.impl.BulkOperationResponseHandler;
import org.ektorp.impl.DocIdResponseHandler;
import org.ektorp.impl.EmbeddedDocViewResponseHandler;
import org.ektorp.impl.JsonSerializer;
import org.ektorp.impl.RevisionResponseHandler;
import org.ektorp.impl.StreamingJsonSerializer;
import org.ektorp.util.Assert;
import org.ektorp.util.Documents;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StdCouchDbConnector
implements CouchDbConnector {
    private static final Logger LOG = LoggerFactory.getLogger(StdCouchDbConnector.class);
    private final ObjectMapper objectMapper;
    private JsonSerializer jsonSerializer;
    private final URI dbURI;
    private final String dbName;
    private final RestTemplate restTemplate;
    private final CouchDbInstance dbInstance;
    private final RevisionResponseHandler revisionHandler;
    private final DocIdResponseHandler docIdResponseHandler;

    public StdCouchDbConnector(String databaseName, CouchDbInstance dbInstance) {
        this(databaseName, dbInstance, new ObjectMapper());
        this.objectMapper.configure(SerializationConfig.Feature.WRITE_DATES_AS_TIMESTAMPS, false);
        this.objectMapper.getSerializationConfig().setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
    }

    public StdCouchDbConnector(String databaseName, CouchDbInstance dbi, ObjectMapper om) {
        Assert.hasText(databaseName, "DatabaseName may not be null or empty");
        Assert.notNull(dbi, "CouchDbInstance may not be null");
        Assert.hasText(databaseName, "JsonFactory may not be null");
        DbPath dbp = DbPath.fromString(databaseName);
        this.dbName = dbp.getDbName();
        this.dbURI = URI.prototype(dbp.getPath());
        this.dbInstance = dbi;
        this.objectMapper = om;
        this.jsonSerializer = new StreamingJsonSerializer(this.objectMapper);
        this.restTemplate = new RestTemplate(dbi.getConnection());
        this.revisionHandler = new RevisionResponseHandler(this.objectMapper);
        this.docIdResponseHandler = new DocIdResponseHandler(this.objectMapper);
    }

    @Override
    public String path() {
        return this.dbURI.toString();
    }

    @Override
    public void create(Object o) {
        DocumentOperationResult result;
        Assert.notNull(o, "Document may not be null");
        Assert.isTrue(Documents.isNew(o), "Object must be new");
        String json = this.jsonSerializer.toJson(o);
        String id = Documents.getId(o);
        if (id != null) {
            if (this.contains(id)) {
                throw new DocumentExistsException(id);
            }
            result = this.restTemplate.put(this.URIWithDocId(id), json, this.revisionHandler);
        } else {
            result = this.restTemplate.post(this.dbURI.toString(), json, this.revisionHandler);
            Documents.setId(o, result.getId());
        }
        Documents.setRevision(o, result.getRevision());
    }

    @Override
    public void create(String id, JsonNode node) {
        this.assertDocIdHasValue(id);
        Assert.notNull(node, "node may not be null");
        this.restTemplate.put(this.URIWithDocId(id), this.jsonSerializer.toJson(node));
    }

    private String URIWithDocId(String id) {
        return this.dbURI.append(id).toString();
    }

    @Override
    public boolean contains(String id) {
        return this.restTemplate.head(this.URIWithDocId(id), new ResponseCallback<Boolean>(){

            @Override
            public Boolean error(HttpResponse hr) {
                if (hr.getCode() == 404) {
                    return Boolean.FALSE;
                }
                throw new DbAccessException(hr.toString());
            }

            @Override
            public Boolean success(HttpResponse hr) throws Exception {
                return Boolean.TRUE;
            }
        });
    }

    @Override
    public String createAttachment(String docId, AttachmentInputStream data) {
        return this.createAttachment(docId, null, data);
    }

    @Override
    public String createAttachment(String docId, String revision, AttachmentInputStream data) {
        this.assertDocIdHasValue(docId);
        URI uri = this.dbURI.append(docId).append(data.getId());
        if (revision != null) {
            uri.param("rev", revision);
        }
        return this.restTemplate.put(uri.toString(), data, data.getContentType(), data.getContentLength(), this.revisionHandler).getRevision();
    }

    @Override
    public AttachmentInputStream getAttachment(String id, String attachmentId) {
        this.assertDocIdHasValue(id);
        Assert.hasText(attachmentId, "attachmentId must have a value");
        if (LOG.isTraceEnabled()) {
            LOG.trace("fetching attachment for doc: {} attachmentId: {}", (Object)id, (Object)attachmentId);
        }
        HttpResponse r = this.restTemplate.get(this.dbURI.append(id).append(attachmentId).toString());
        return new AttachmentInputStream(attachmentId, r.getContent(), r.getContentType(), r.getContentLength());
    }

    @Override
    public String delete(Object o) {
        Assert.notNull(o, "document may not be null");
        return this.delete(Documents.getId(o), Documents.getRevision(o));
    }

    @Override
    public <T> T get(final Class<T> c, String id) {
        Assert.notNull(c, "Class may not be null");
        this.assertDocIdHasValue(id);
        return this.restTemplate.get(this.URIWithDocId(id), new StdResponseHandler<T>(){

            @Override
            public T success(HttpResponse hr) throws Exception {
                return StdCouchDbConnector.this.objectMapper.readValue(hr.getContent(), c);
            }
        });
    }

    @Override
    public <T> T get(final Class<T> c, String id, String rev) {
        Assert.notNull(c, "Class may not be null");
        this.assertDocIdHasValue(id);
        Assert.hasText(rev, "Revision may not be null or empty");
        return this.restTemplate.get(this.dbURI.append(id).param("rev", rev).toString(), new StdResponseHandler<T>(){

            @Override
            public T success(HttpResponse hr) throws Exception {
                return StdCouchDbConnector.this.objectMapper.readValue(hr.getContent(), c);
            }
        });
    }

    @Override
    public List<Revision> getRevisions(String id) {
        this.assertDocIdHasValue(id);
        return this.restTemplate.get(this.dbURI.append(id).param("revs_info", "true").toString(), new StdResponseHandler<List<Revision>>(){

            @Override
            public List<Revision> success(HttpResponse hr) throws Exception {
                JsonNode root = (JsonNode)StdCouchDbConnector.this.objectMapper.readValue(hr.getContent(), JsonNode.class);
                ArrayList<Revision> revs = new ArrayList<Revision>();
                Iterator i = root.get("_revs_info").getElements();
                while (i.hasNext()) {
                    JsonNode rev = (JsonNode)i.next();
                    revs.add(new Revision(rev.get("rev").getTextValue(), rev.get("status").getTextValue()));
                }
                return revs;
            }

            @Override
            public List<Revision> error(HttpResponse hr) {
                if (hr.getCode() == 404) {
                    return Collections.emptyList();
                }
                return (List)super.error(hr);
            }
        });
    }

    @Override
    public InputStream getAsStream(String id) {
        this.assertDocIdHasValue(id);
        HttpResponse r = this.restTemplate.get(this.dbURI.append(id).toString());
        return r.getContent();
    }

    @Override
    public InputStream getAsStream(String id, String rev) {
        this.assertDocIdHasValue(id);
        Assert.hasText(rev, "Revision may not be null or empty");
        HttpResponse r = this.restTemplate.get(this.dbURI.append(id).param("rev", rev).toString());
        return r.getContent();
    }

    @Override
    public void update(final Object o) {
        Assert.notNull(o, "Document cannot be null");
        final String id = Documents.getId(o);
        this.assertDocIdHasValue(id);
        this.restTemplate.put(this.dbURI.append(id).toString(), this.jsonSerializer.toJson(o), new StdResponseHandler<Void>(){

            @Override
            public Void success(HttpResponse hr) throws Exception {
                JsonNode n = (JsonNode)StdCouchDbConnector.this.objectMapper.readValue(hr.getContent(), JsonNode.class);
                Documents.setRevision(o, n.get("rev").getTextValue());
                return null;
            }

            @Override
            public Void error(HttpResponse hr) {
                if (hr.getCode() == 409) {
                    throw new UpdateConflictException(id, Documents.getRevision(o));
                }
                return (Void)super.error(hr);
            }
        });
    }

    @Override
    public String delete(String id, String revision) {
        this.assertDocIdHasValue(id);
        return this.restTemplate.delete(this.dbURI.append(id).param("rev", revision).toString(), this.revisionHandler).getRevision();
    }

    @Override
    public List<String> getAllDocIds() {
        return this.restTemplate.get(this.dbURI.append("_all_docs").toString(), this.docIdResponseHandler);
    }

    @Override
    public void createDatabaseIfNotExists() {
        if (!this.dbInstance.getAllDatabases().contains(this.dbName)) {
            this.dbInstance.createDatabase(this.dbName);
        }
    }

    @Override
    public String getDatabaseName() {
        return this.dbName;
    }

    @Override
    public <T> List<T> queryView(ViewQuery query, Class<T> type) {
        Assert.notNull(query, "query may not be null");
        query.dbPath(this.dbURI.toString());
        EmbeddedDocViewResponseHandler<T> rh = new EmbeddedDocViewResponseHandler<T>(type, this.objectMapper);
        return query.hasMultipleKeys() ? (List)this.restTemplate.post(query.buildQuery(), query.getKeysAsJson(), rh) : (List)this.restTemplate.get(query.buildQuery(), rh);
    }

    @Override
    public ViewResult queryView(ViewQuery query) {
        Assert.notNull(query, "query cannot be null");
        query.dbPath(this.dbURI.toString());
        StdResponseHandler<ViewResult> rh = new StdResponseHandler<ViewResult>(){

            @Override
            public ViewResult success(HttpResponse hr) throws Exception {
                return new ViewResult(StdCouchDbConnector.this.objectMapper.readTree(hr.getContent()));
            }
        };
        return query.hasMultipleKeys() ? this.restTemplate.post(query.buildQuery(), query.getKeysAsJson(), rh) : this.restTemplate.get(query.buildQuery(), rh);
    }

    @Override
    public InputStream queryForStream(ViewQuery query) {
        Assert.notNull(query, "query cannot be null");
        query.dbPath(this.dbURI.toString());
        return query.hasMultipleKeys() ? this.restTemplate.post(query.buildQuery(), query.getKeysAsJson()).getContent() : this.restTemplate.get(query.buildQuery()).getContent();
    }

    @Override
    public String deleteAttachment(String docId, String revision, String attachmentId) {
        return this.restTemplate.delete(this.dbURI.append(docId).append(attachmentId).param("rev", revision).toString(), this.revisionHandler).getRevision();
    }

    private void assertDocIdHasValue(String docId) {
        Assert.hasText(docId, "document id cannot be empty");
    }

    @Override
    public HttpClient getConnection() {
        return this.dbInstance.getConnection();
    }

    @Override
    public DbInfo getDbInfo() {
        return this.restTemplate.get(this.dbURI.toString(), new StdResponseHandler<DbInfo>(){

            @Override
            public DbInfo success(HttpResponse hr) throws Exception {
                return (DbInfo)StdCouchDbConnector.this.objectMapper.readValue(hr.getContent(), DbInfo.class);
            }
        });
    }

    @Override
    public void compact() {
        this.restTemplate.post(this.dbURI.append("_compact").toString(), "not_used");
    }

    @Override
    public void cleanupViews() {
        this.restTemplate.post(this.dbURI.append("_view_cleanup").toString(), "not_used");
    }

    @Override
    public ReplicationStatus replicateFrom(String source) {
        ReplicationCommand cmd = new ReplicationCommand.Builder().target(this.dbName).source(source).build();
        return this.dbInstance.replicate(cmd);
    }

    @Override
    public ReplicationStatus replicateTo(String target) {
        ReplicationCommand cmd = new ReplicationCommand.Builder().target(target).source(this.dbName).build();
        return this.dbInstance.replicate(cmd);
    }

    @Override
    public void compactViews(String designDocumentId) {
        Assert.hasText(designDocumentId, "designDocumentId may not be null or empty");
        this.restTemplate.post(this.dbURI.append("_compact").append(designDocumentId).toString(), "not_used");
    }

    @Override
    public List<DocumentOperationResult> executeAllOrNothing(Collection<?> objects) {
        return this.executeBulk(objects, true);
    }

    @Override
    public List<DocumentOperationResult> executeBulk(Collection<?> objects) {
        return this.executeBulk(objects, false);
    }

    public void setJsonSerializer(JsonSerializer js) {
        Assert.notNull(js, "JsonSerializer may not be null");
        this.jsonSerializer = js;
    }

    private List<DocumentOperationResult> executeBulk(Collection<?> objects, boolean allOrNothing) {
        BulkOperation op = this.jsonSerializer.createBulkOperation(objects, allOrNothing);
        List<DocumentOperationResult> result = this.restTemplate.post(this.dbURI.append("_bulk_docs").toString(), op.getData(), new BulkOperationResponseHandler(objects, this.objectMapper));
        op.awaitCompletion();
        return result;
    }

    @Override
    public int getRevisionLimit() {
        return this.restTemplate.get(this.dbURI.append("_revs_limit").toString(), new StdResponseHandler<Integer>(){

            @Override
            public Integer success(HttpResponse hr) throws Exception {
                JsonNode rlimit = StdCouchDbConnector.this.objectMapper.readTree(hr.getContent());
                return rlimit.getValueAsInt();
            }
        });
    }

    @Override
    public void setRevisionLimit(int limit) {
        this.restTemplate.put(this.dbURI.append("_revs_limit").toString(), Integer.toString(limit));
    }
}

