/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.support;

import java.util.ArrayList;
import java.util.List;
import org.ektorp.ComplexKey;
import org.ektorp.CouchDbConnector;
import org.ektorp.ViewQuery;
import org.ektorp.support.DesignDocument;
import org.ektorp.support.DesignDocumentFactory;
import org.ektorp.support.GenericRepository;
import org.ektorp.support.StdDesignDocumentFactory;
import org.ektorp.util.Assert;
import org.ektorp.util.Documents;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CouchDbRepositorySupport<T>
implements GenericRepository<T> {
    public static final String AUTO_UPDATE_VIEW_ON_CHANGE = "org.ektorp.support.AutoUpdateViewOnChange";
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final CouchDbConnector db;
    private final Class<T> type;
    private final String stdDesignDocumentId;
    private DesignDocumentFactory designDocumentFactory;

    protected CouchDbRepositorySupport(Class<T> type, CouchDbConnector db) {
        Assert.notNull(db, "CouchDbConnector may not be null");
        Assert.notNull(type);
        this.db = db;
        this.type = type;
        db.createDatabaseIfNotExists();
        this.stdDesignDocumentId = "_design/" + type.getSimpleName();
    }

    @Override
    public void add(T entity) {
        this.assertEntityNotNull(entity);
        Assert.isTrue(Documents.isNew(entity), "entity must be new");
        this.db.create(entity);
    }

    @Override
    public List<T> getAll() {
        if (this.designDocContainsAllView()) {
            return this.queryView("all");
        }
        return this.loadAllByAllDocIds();
    }

    private boolean designDocContainsAllView() {
        if (this.db.contains(this.stdDesignDocumentId)) {
            DesignDocument dd = this.db.get(DesignDocument.class, this.stdDesignDocumentId);
            return dd.containsView("all");
        }
        return false;
    }

    private List<T> loadAllByAllDocIds() {
        List<String> ids = this.db.getAllDocIds();
        ArrayList<T> all = new ArrayList<T>(ids.size());
        for (String id : ids) {
            if (id.startsWith("_design")) continue;
            all.add(this.get(id));
        }
        return all;
    }

    @Override
    public T get(String id) {
        return this.db.get(this.type, id);
    }

    @Override
    public T get(String id, String rev) {
        return this.db.get(this.type, id, rev);
    }

    @Override
    public void remove(T entity) {
        this.assertEntityNotNull(entity);
        this.db.delete(Documents.getId(entity), Documents.getRevision(entity));
    }

    @Override
    public void update(T entity) {
        this.assertEntityNotNull(entity);
        this.db.update(entity);
    }

    private void assertEntityNotNull(T entity) {
        Assert.notNull(entity, "entity may not be null");
    }

    protected ViewQuery createQuery(String viewName) {
        return new ViewQuery().dbPath(this.db.path()).designDocId(this.stdDesignDocumentId).viewName(viewName);
    }

    protected List<T> queryView(String viewName, String key) {
        return this.db.queryView(this.createQuery(viewName).includeDocs(true).key(key), this.type);
    }

    protected List<T> queryView(String viewName, int key) {
        return this.db.queryView(this.createQuery(viewName).includeDocs(true).key(key), this.type);
    }

    protected List<T> queryView(String viewName, ComplexKey key) {
        return this.db.queryView(this.createQuery(viewName).includeDocs(true).key(key), this.type);
    }

    protected List<T> queryView(String viewName) {
        return this.db.queryView(this.createQuery(viewName).includeDocs(true), this.type);
    }

    public void initStandardDesignDocument() {
        DesignDocument generated;
        String id = "_design/" + this.type.getSimpleName();
        DesignDocument designDoc = this.db.contains(id) ? this.db.get(DesignDocument.class, id) : new DesignDocument(id);
        boolean changed = designDoc.mergeWith(generated = this.getDesignDocumentFactory().generateFrom(this));
        if (changed) {
            this.db.update(designDoc);
        }
    }

    @Override
    public boolean contains(String docId) {
        return this.db.contains(docId);
    }

    public void setDesignDocumentFactory(DesignDocumentFactory df) {
        this.designDocumentFactory = df;
    }

    protected DesignDocumentFactory getDesignDocumentFactory() {
        if (this.designDocumentFactory == null) {
            this.designDocumentFactory = new StdDesignDocumentFactory();
        }
        return this.designDocumentFactory;
    }

    Class<?> getHandledType() {
        return this.type;
    }
}

