/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.support;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.jackson.map.ObjectMapper;
import org.ektorp.support.CouchDbRepositorySupport;
import org.ektorp.support.DesignDocument;
import org.ektorp.support.GenerateView;
import org.ektorp.support.View;
import org.ektorp.support.ViewGenerationException;
import org.ektorp.support.Views;
import org.ektorp.util.Exceptions;
import org.ektorp.util.Predicate;
import org.ektorp.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleViewGenerator {
    private static final String LOOKUP_BY_PROPERTY_TEMPLATE = "function(doc) { if(doc.%s) {emit(doc.%s, doc._id)} }";
    private static final String LOOKUP_BY_ITERABLE_PROPERTY_TEMPLATE = "function(doc) {for (var i in doc.%s) {emit(doc.%s[i], doc._id);}}";
    private SoftReference<ObjectMapper> mapperRef;

    public DesignDocument.View generateFindByView(String propertyName) {
        return new DesignDocument.View(String.format(LOOKUP_BY_PROPERTY_TEMPLATE, propertyName, propertyName));
    }

    public DesignDocument.View generateFindByIterableView(String propertyName) {
        return new DesignDocument.View(String.format(LOOKUP_BY_ITERABLE_PROPERTY_TEMPLATE, propertyName, propertyName));
    }

    public Map<String, DesignDocument.View> generateViews(Object repository) {
        final HashMap<String, DesignDocument.View> views = new HashMap<String, DesignDocument.View>();
        final Class<?> repositoryClass = repository.getClass();
        final Class<?> handledType = repository instanceof CouchDbRepositorySupport ? ((CouchDbRepositorySupport)repository).getHandledType() : null;
        ReflectionUtils.eachAnnotation(repositoryClass, Views.class, new Predicate<Views>(){

            @Override
            public boolean apply(Views input) {
                for (View v : input.value()) {
                    SimpleViewGenerator.this.addView(views, v, repositoryClass);
                }
                return true;
            }
        });
        ReflectionUtils.eachAnnotation(repositoryClass, View.class, new Predicate<View>(){

            @Override
            public boolean apply(View input) {
                SimpleViewGenerator.this.addView(views, input, repositoryClass);
                return true;
            }
        });
        ReflectionUtils.eachAnnotatedMethod(repositoryClass, GenerateView.class, new Predicate<Method>(){

            @Override
            public boolean apply(Method input) {
                SimpleViewGenerator.this.generateView(views, input, handledType);
                return true;
            }
        });
        return views;
    }

    private void addView(Map<String, DesignDocument.View> views, View input, Class<?> repositoryClass) {
        if (input.file().length() > 0) {
            views.put(input.name(), this.loadViewFromFile(views, input, repositoryClass));
        } else {
            views.put(input.name(), DesignDocument.View.of(input));
        }
    }

    private DesignDocument.View loadViewFromFile(Map<String, DesignDocument.View> views, View input, Class<?> repositoryClass) {
        try {
            InputStream in = repositoryClass.getResourceAsStream(input.file());
            if (in == null) {
                throw new FileNotFoundException("Could not load view file with path: " + input.file());
            }
            return (DesignDocument.View)this.mapper().readValue(in, DesignDocument.View.class);
        }
        catch (Exception e) {
            throw Exceptions.propagate(e);
        }
    }

    private boolean isIterable(Class<?> type) {
        return Iterable.class.isAssignableFrom(type);
    }

    private void generateView(Map<String, DesignDocument.View> views, Method me, Class<?> handledType) {
        String name = me.getName();
        if (!name.startsWith("findBy")) {
            throw new ViewGenerationException("Method annotated with GenerateView does not conform to the naming convention of 'findByXxxx'");
        }
        Class<?> type = this.resolveReturnType(me);
        if (type == null) {
            if (handledType != null) {
                type = handledType;
            } else {
                throw new ViewGenerationException("Could not resolve return type for method %s", me.getName());
            }
        }
        String finderName = name.substring(6);
        String fieldName = this.resolveFieldName(me, finderName);
        Method getter = ReflectionUtils.findMethod(type, "get" + fieldName);
        if (getter == null) {
            fieldName = fieldName + "s";
            getter = ReflectionUtils.findMethod(type, "get" + fieldName);
        }
        if (getter == null) {
            throw new ViewGenerationException("Could not generate view for method %s. No get method found for property %s in %s", name, name.substring(6), type);
        }
        fieldName = this.firstCharToLowerCase(fieldName);
        DesignDocument.View view = this.isIterable(getter.getReturnType()) ? this.generateFindByIterableView(fieldName) : this.generateFindByView(fieldName);
        views.put("by_" + this.firstCharToLowerCase(finderName), view);
    }

    private String resolveFieldName(Method me, String finderName) {
        GenerateView g = me.getAnnotation(GenerateView.class);
        String field = g.field();
        return field.length() == 0 ? finderName : g.field();
    }

    private String firstCharToLowerCase(String name) {
        return Character.toString(Character.toLowerCase(name.charAt(0))) + name.substring(1);
    }

    private Class<?> resolveReturnType(Method me) {
        Type returnType = me.getGenericReturnType();
        if (returnType instanceof ParameterizedType) {
            Type[] typeArguments;
            ParameterizedType type = (ParameterizedType)returnType;
            for (Type typeArgument : typeArguments = type.getActualTypeArguments()) {
                if (!(typeArgument instanceof Class)) continue;
                return (Class)typeArgument;
            }
            return null;
        }
        return (Class)returnType;
    }

    private ObjectMapper mapper() {
        ObjectMapper mapper;
        if (this.mapperRef == null) {
            this.mapperRef = new SoftReference<ObjectMapper>(new ObjectMapper());
        }
        if ((mapper = this.mapperRef.get()) == null) {
            mapper = new ObjectMapper();
            this.mapperRef = new SoftReference<ObjectMapper>(mapper);
        }
        return mapper;
    }
}

