/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import org.ektorp.util.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionUtils {
    public static void eachAnnotatedMethod(Class<?> clazz, Class<? extends Annotation> annotationClass, Predicate<Method> p) {
        for (Method me : clazz.getDeclaredMethods()) {
            Annotation a = me.getAnnotation(annotationClass);
            if (a == null) continue;
            p.apply(me);
        }
        if (clazz.getSuperclass() != null) {
            ReflectionUtils.eachAnnotatedMethod(clazz.getSuperclass(), annotationClass, p);
        }
    }

    public static <T extends Annotation> void eachAnnotation(Class<?> clazz, Class<T> annotationClass, Predicate<T> p) {
        T a = clazz.getAnnotation(annotationClass);
        if (a != null) {
            p.apply(a);
        }
        for (Method me : clazz.getDeclaredMethods()) {
            a = me.getAnnotation(annotationClass);
            if (a == null) continue;
            p.apply(a);
        }
        if (clazz.getSuperclass() != null) {
            ReflectionUtils.eachAnnotation(clazz.getSuperclass(), annotationClass, p);
        }
    }

    public static List<Method> findAnnotatedMethods(Class<?> clazz, Class<? extends Annotation> annotationClass) {
        LinkedList<Method> result = new LinkedList<Method>();
        for (Method me : clazz.getDeclaredMethods()) {
            Annotation a = me.getAnnotation(annotationClass);
            if (a == null) continue;
            result.add(me);
        }
        if (clazz.getSuperclass() != null) {
            result.addAll(ReflectionUtils.findAnnotatedMethods(clazz.getSuperclass(), annotationClass));
        }
        return result;
    }

    public static Method findMethod(Class<?> clazz, String name) {
        for (Method me : clazz.getDeclaredMethods()) {
            if (!me.getName().equalsIgnoreCase(name)) continue;
            return me;
        }
        if (clazz.getSuperclass() != null) {
            return ReflectionUtils.findMethod(clazz.getSuperclass(), name);
        }
        return null;
    }

    public static interface AnnotationPredicate {
        public boolean equals(Method var1, Annotation var2);
    }
}

