/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.impl;

import org.codehaus.jackson.map.DeserializerFactory;
import org.codehaus.jackson.map.DeserializerProvider;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.SerializerFactory;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.codehaus.jackson.map.deser.StdDeserializerProvider;
import org.ektorp.CouchDbConnector;
import org.ektorp.impl.ObjectMapperFactory;
import org.ektorp.impl.docref.DocumentReferenceDeserializerFactory;
import org.ektorp.impl.docref.DocumentReferenceSerializerFactory;
import org.ektorp.impl.docref.DocumentReferenceSerializerProvider;
import org.ektorp.util.Assert;
import org.ektorp.util.Exceptions;

public class StdObjectMapperFactory
implements ObjectMapperFactory {
    private ObjectMapper instance;
    private boolean writeDatesAsTimestamps = false;

    public synchronized ObjectMapper createObjectMapper() {
        if (this.instance == null) {
            this.instance = new ObjectMapper();
            this.applyDefaultConfiguration(this.instance);
        }
        return this.instance;
    }

    public ObjectMapper createObjectMapper(CouchDbConnector connector) {
        DocumentReferenceDeserializerFactory dsf;
        ObjectMapper objectMapper = new ObjectMapper();
        this.applyDefaultConfiguration(objectMapper);
        try {
            dsf = new DocumentReferenceDeserializerFactory(connector, objectMapper);
        }
        catch (JsonMappingException e) {
            throw Exceptions.propagate(e);
        }
        StdDeserializerProvider dp = new StdDeserializerProvider((DeserializerFactory)dsf);
        objectMapper.setDeserializerProvider((DeserializerProvider)dp);
        DocumentReferenceSerializerFactory sf = new DocumentReferenceSerializerFactory(connector);
        DocumentReferenceSerializerProvider dsp = new DocumentReferenceSerializerProvider(objectMapper.getSerializationConfig(), sf, objectMapper.getSerializerProvider());
        objectMapper.setSerializerProvider((SerializerProvider)dsp);
        objectMapper.setSerializerFactory((SerializerFactory)sf);
        return objectMapper;
    }

    public synchronized void setObjectMapper(ObjectMapper om) {
        Assert.notNull(om, "ObjectMapper may not be null");
        this.instance = om;
    }

    public void setWriteDatesAsTimestamps(boolean b) {
        this.writeDatesAsTimestamps = b;
    }

    private void applyDefaultConfiguration(ObjectMapper om) {
        om.configure(SerializationConfig.Feature.WRITE_DATES_AS_TIMESTAMPS, this.writeDatesAsTimestamps);
        om.getSerializationConfig().setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
    }
}

