/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.impl.docref;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.jackson.map.BeanProperty;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.SerializerFactory;
import org.codehaus.jackson.map.introspect.AnnotatedField;
import org.codehaus.jackson.map.introspect.BasicBeanDescription;
import org.codehaus.jackson.map.ser.BeanPropertyWriter;
import org.codehaus.jackson.map.ser.BeanSerializer;
import org.codehaus.jackson.map.ser.BeanSerializerBuilder;
import org.codehaus.jackson.map.ser.BeanSerializerFactory;
import org.codehaus.jackson.map.type.TypeFactory;
import org.ektorp.CouchDbConnector;
import org.ektorp.docref.DocumentReferences;
import org.ektorp.impl.docref.BackReferencedBeanSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentReferenceSerializerFactory
extends BeanSerializerFactory {
    private final CouchDbConnector couchDbConnector;

    public DocumentReferenceSerializerFactory(CouchDbConnector couchDbConnector) {
        super(null);
        this.couchDbConnector = couchDbConnector;
    }

    public DocumentReferenceSerializerFactory(SerializerFactory.Config config, CouchDbConnector couchDbConnector) {
        super(config);
        this.couchDbConnector = couchDbConnector;
    }

    public SerializerFactory withConfig(SerializerFactory.Config config) {
        return new DocumentReferenceSerializerFactory(config, this.couchDbConnector);
    }

    protected JsonSerializer<Object> constructBeanSerializer(SerializationConfig config, BasicBeanDescription beanDesc, BeanProperty property) {
        List<AnnotatedField> docRefs = this.findDocumentReferenceFields(beanDesc);
        if (docRefs.size() > 0) {
            List props = this.findBeanProperties(config, beanDesc);
            BeanPropertyWriter[] filter = this.createDocumentReferenceFieldFilters(docRefs, props);
            BeanSerializerBuilder builder = new BeanSerializerBuilder(beanDesc);
            builder.setFilteredProperties(filter);
            return new BackReferencedBeanSerializer((JsonSerializer<Object>)((BeanSerializer)builder.build()), this.findWriters(docRefs, config, beanDesc, props), this.couchDbConnector);
        }
        return super.constructBeanSerializer(config, beanDesc, property);
    }

    public boolean hasDocumentReferenceFields(SerializationConfig config, Object value) {
        BasicBeanDescription beanDesc = (BasicBeanDescription)config.introspect(TypeFactory.type(value.getClass()));
        List<AnnotatedField> docRefs = this.findDocumentReferenceFields(beanDesc);
        return docRefs.size() > 0;
    }

    private List<AnnotatedField> findDocumentReferenceFields(BasicBeanDescription beanDesc) {
        ArrayList<AnnotatedField> docRefs = new ArrayList<AnnotatedField>();
        for (AnnotatedField field : beanDesc.getClassInfo().fields()) {
            if (!field.hasAnnotation(DocumentReferences.class)) continue;
            docRefs.add(field);
        }
        return docRefs;
    }

    public BeanPropertyWriter[] createDocumentReferenceFieldFilters(List<AnnotatedField> docRefs, List<BeanPropertyWriter> props) {
        BeanPropertyWriter[] writers = props.toArray(new BeanPropertyWriter[props.size()]);
        for (int i = 0; i < writers.length; ++i) {
            for (AnnotatedField field : docRefs) {
                if (writers[i] == null || !field.getName().equals(writers[i].getName())) continue;
                writers[i] = null;
            }
        }
        return writers;
    }

    private List<BeanPropertyWriter> findWriters(List<AnnotatedField> docRefs, SerializationConfig config, BasicBeanDescription beanDesc, List<BeanPropertyWriter> props) {
        ArrayList<BeanPropertyWriter> filteredProps = new ArrayList<BeanPropertyWriter>();
        for (AnnotatedField field : docRefs) {
            for (BeanPropertyWriter writer : props) {
                if (!writer.getName().equals(field.getName())) continue;
                filteredProps.add(writer);
            }
        }
        return filteredProps;
    }
}

