/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.util;

import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassHierarchyMap<V>
implements Map<Class<?>, V> {
    private final Map<Class<?>, V> map;

    public ClassHierarchyMap() {
        this.map = new IdentityHashMap();
    }

    public ClassHierarchyMap(int capacity) {
        this.map = new IdentityHashMap(capacity);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key) ? true : this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Set<Map.Entry<Class<?>, V>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public V get(Object key) {
        V v = this.map.get(key);
        if (v != null) {
            return v;
        }
        Class c = (Class)key;
        Class<?>[] interfaces = c.getInterfaces();
        v = this.searchHierachy(interfaces);
        if (v == null) {
            v = this.searchHierachy(c.getSuperclass());
        }
        if (v != null) {
            this.map.put(c, v);
        }
        return v;
    }

    private V searchHierachy(Class<?> superclass) {
        if (superclass == null) {
            return null;
        }
        V v = this.map.get(superclass);
        return v != null ? v : this.searchHierachy(superclass.getSuperclass());
    }

    private V searchHierachy(Class<?>[] interfaces) {
        V v = null;
        for (Class<?> i : interfaces) {
            v = this.map.get(i);
            if (v != null) {
                return v;
            }
            if (i.getInterfaces().length <= 0 || (v = (V)this.searchHierachy(i.getInterfaces())) == null) continue;
            return v;
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<Class<?>> keySet() {
        return this.map.keySet();
    }

    @Override
    public V put(Class<?> key, V value) {
        return this.map.put(key, value);
    }

    @Override
    public void putAll(Map<? extends Class<?>, ? extends V> t) {
        this.map.putAll(t);
    }

    @Override
    public V remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }
}

