/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp;

import java.io.Serializable;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.ektorp.util.Assert;

@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class Attachment
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String id;
    private String contentType;
    private long length;
    private String dataBase64;
    private boolean stub;
    private int revpos;

    public Attachment(String id, String data, String contentType) {
        Assert.hasText(id, "attachmentId must have a value");
        Assert.hasText(contentType, "contentType must have a value");
        Assert.notNull(data, "data input stream cannot be null");
        this.id = id;
        this.contentType = contentType;
        this.dataBase64 = data;
        this.length = data.getBytes().length;
    }

    Attachment() {
    }

    @JsonProperty(value="content_type")
    public String getContentType() {
        return this.contentType;
    }

    @JsonProperty(value="content_type")
    void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @JsonIgnore
    public long getContentLength() {
        return this.length;
    }

    @JsonProperty(value="data")
    public String getDataBase64() {
        return this.dataBase64;
    }

    @JsonIgnore
    public String getId() {
        return this.id;
    }

    @JsonIgnore
    void setId(String id) {
        this.id = id;
    }

    void setLength(int contentLength) {
        this.length = contentLength;
    }

    public boolean isStub() {
        return this.stub;
    }

    void setStub(boolean stub) {
        this.stub = stub;
    }

    public int getRevpos() {
        return this.revpos;
    }

    public void setRevpos(int revpos) {
        this.revpos = revpos;
    }
}

