/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.changes;

import org.ektorp.http.URI;

public class ChangesCommand {
    public final int since;
    public final boolean continuous;
    public final String filter;
    public final boolean includeDocs;
    public final int heartbeat;
    private String queryString;

    private ChangesCommand(Builder b) {
        this.continuous = b.continuous;
        this.since = b.since > -1 ? b.since : -1;
        this.filter = b.filter;
        this.includeDocs = b.includeDocs;
        this.heartbeat = b.heartbeat;
    }

    public String toString() {
        if (this.queryString == null) {
            URI uri = URI.of("_changes");
            if (this.continuous) {
                uri.param("feed", "continuous");
            }
            if (this.since > -1) {
                uri.param("since", this.since);
            }
            if (this.filter != null) {
                uri.param("filter", this.filter);
            }
            if (this.includeDocs) {
                uri.param("include_docs", "true");
            }
            if (this.heartbeat > 0) {
                uri.param("heartbeat", this.heartbeat);
            }
            this.queryString = uri.toString();
        }
        return this.queryString;
    }

    public static class Builder {
        private int since = -1;
        private boolean continuous;
        private String filter;
        private boolean includeDocs;
        private int heartbeat = -1;

        public Builder since(int i) {
            this.since = i;
            return this;
        }

        public Builder continuous(boolean b) {
            this.continuous = b;
            return this;
        }

        public Builder filter(String s) {
            this.filter = s;
            return this;
        }

        public Builder includeDocs(boolean b) {
            this.includeDocs = b;
            return this;
        }

        public Builder heartbeat(int i) {
            this.heartbeat = i;
            return this;
        }

        public Builder merge(ChangesCommand other) {
            this.continuous = other.continuous;
            this.filter = other.filter;
            this.includeDocs = other.includeDocs;
            this.since = other.since;
            return this;
        }

        public ChangesCommand build() {
            return new ChangesCommand(this);
        }
    }
}

