/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.http;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.conn.ClientConnectionManager;

public class IdleConnectionMonitor {
    private static final long DEFAULT_IDLE_CHECK_INTERVAL = 30L;
    private static final ScheduledExecutorService executorService = Executors.newScheduledThreadPool(1, new ThreadFactory(){
        private final AtomicInteger threadCount = new AtomicInteger(0);

        public Thread newThread(Runnable r) {
            Thread t = new Thread();
            t.setDaemon(true);
            t.setName(String.format("ektorp-idle-connection-monitor-thread-%s", this.threadCount.incrementAndGet()));
            return t;
        }
    });

    public static void monitor(ClientConnectionManager cm) {
        executorService.scheduleWithFixedDelay(new CleanupTask(cm), 30L, 30L, TimeUnit.SECONDS);
    }

    private static class CleanupTask
    implements Runnable {
        final ClientConnectionManager cm;

        CleanupTask(ClientConnectionManager cm) {
            this.cm = cm;
        }

        public void run() {
            this.cm.closeExpiredConnections();
        }
    }
}

