/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.impl.changes;

import org.codehaus.jackson.JsonNode;
import org.ektorp.changes.DocumentChange;
import org.ektorp.util.Assert;

public class StdDocumentChange
implements DocumentChange {
    private static final String REV_FIELD_NAME = "rev";
    private static final String SEQ_FIELD_NAME = "seq";
    private static final String ID_FIELD_NAME = "id";
    private static final String DOC_FIELD_NAME = "doc";
    private static final String DELETED_FIELD_NAME = "deleted";
    private final JsonNode node;

    public StdDocumentChange(JsonNode node) {
        Assert.notNull(node, "node may not be null");
        this.node = node;
    }

    public int getSequence() {
        return this.node.get(SEQ_FIELD_NAME).getIntValue();
    }

    public String getId() {
        return this.node.get(ID_FIELD_NAME).getTextValue();
    }

    public boolean isDeleted() {
        JsonNode deleted = this.node.findPath(DELETED_FIELD_NAME);
        return !deleted.isMissingNode() && deleted.getBooleanValue();
    }

    public String getDoc() {
        return this.nodeAsString(this.node.findValue(DOC_FIELD_NAME));
    }

    public JsonNode getDocAsNode() {
        return this.node.findPath(DOC_FIELD_NAME);
    }

    private String nodeAsString(JsonNode node) {
        if (this.isNull(node)) {
            return null;
        }
        return node.isContainerNode() ? node.toString() : node.getValueAsText();
    }

    private boolean isNull(JsonNode node) {
        return node == null || node.isNull() || node.isMissingNode();
    }

    public String getRevision() {
        return this.nodeAsString(this.node.findPath(REV_FIELD_NAME));
    }

    public String toString() {
        return this.node.toString();
    }
}

