/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.impl.docref;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.List;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.DeserializerProvider;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.ResolvableDeserializer;
import org.codehaus.jackson.map.deser.BeanDeserializer;
import org.codehaus.jackson.map.deser.StdDeserializer;
import org.ektorp.CouchDbConnector;
import org.ektorp.docref.DocumentReferences;
import org.ektorp.docref.FetchType;
import org.ektorp.impl.docref.ConstructibleAnnotatedCollection;
import org.ektorp.impl.docref.LazyLoadingViewBasedCollection;
import org.ektorp.impl.docref.ViewBasedCollection;
import org.ektorp.util.Documents;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackReferencedBeanDeserializer
extends StdDeserializer<Object>
implements ResolvableDeserializer {
    private final CouchDbConnector couchDbConnector;
    private final BeanDeserializer delegate;
    private final List<ConstructibleAnnotatedCollection> backReferencedFields;
    private final Class<?> clazz;
    private final ObjectMapper objectMapper;

    BackReferencedBeanDeserializer(BeanDeserializer deserializer, List<ConstructibleAnnotatedCollection> fields, CouchDbConnector couchDbConnector, Class<?> clazz, ObjectMapper objectMapper) {
        super(clazz);
        this.clazz = clazz;
        this.delegate = deserializer;
        this.couchDbConnector = couchDbConnector;
        this.backReferencedFields = fields;
        this.objectMapper = objectMapper;
    }

    public Object deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        Object deserializedObject = this.delegate.deserialize(jp, ctxt);
        this.addbackReferencedFields(deserializedObject, ctxt);
        return deserializedObject;
    }

    private void addbackReferencedFields(Object deserializedObject, DeserializationContext ctxt) throws IOException {
        String id = Documents.getId(deserializedObject);
        for (ConstructibleAnnotatedCollection constructibleField : this.backReferencedFields) {
            DocumentReferences ann = (DocumentReferences)constructibleField.getField().getAnnotation(DocumentReferences.class);
            try {
                ViewBasedCollection handler;
                if (ann.fetch().equals((Object)FetchType.EAGER)) {
                    handler = new ViewBasedCollection(id, this.couchDbConnector, this.clazz, ann, constructibleField, this.objectMapper);
                    handler.initialize();
                } else {
                    handler = new LazyLoadingViewBasedCollection(id, this.couchDbConnector, this.clazz, ann, constructibleField, this.objectMapper);
                }
                Object o = Proxy.newProxyInstance(constructibleField.getCollectionType().getRawClass().getClassLoader(), new Class[]{constructibleField.getCollectionType().getRawClass()}, (InvocationHandler)handler);
                constructibleField.getSetter().set(deserializedObject, o);
            }
            catch (Exception e) {
                throw new IOException("Failed creating reflection proxy for collection " + constructibleField, e);
            }
        }
    }

    public Object deserialize(JsonParser jp, DeserializationContext ctxt, Object intoValue) throws IOException, JsonProcessingException {
        Object deserializedObject = super.deserialize(jp, ctxt, intoValue);
        this.addbackReferencedFields(deserializedObject, ctxt);
        return deserializedObject;
    }

    public void resolve(DeserializationConfig config, DeserializerProvider provider) throws JsonMappingException {
        this.delegate.resolve(config, provider);
    }
}

