/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.impl.docref;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.map.BeanProperty;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.DeserializerProvider;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.deser.BeanDeserializer;
import org.codehaus.jackson.map.deser.BeanDeserializerFactory;
import org.codehaus.jackson.map.introspect.AnnotatedField;
import org.codehaus.jackson.map.introspect.AnnotatedMethod;
import org.codehaus.jackson.map.introspect.BasicBeanDescription;
import org.codehaus.jackson.map.introspect.VisibilityChecker;
import org.codehaus.jackson.map.type.CollectionType;
import org.codehaus.jackson.map.type.TypeBindings;
import org.codehaus.jackson.map.util.ClassUtil;
import org.codehaus.jackson.type.JavaType;
import org.ektorp.CouchDbConnector;
import org.ektorp.docref.DocumentReferences;
import org.ektorp.impl.docref.BackReferencedBeanDeserializer;
import org.ektorp.impl.docref.ConstructibleAnnotatedCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentReferenceDeserializerFactory
extends BeanDeserializerFactory {
    private final CouchDbConnector couchDbConnector;
    private final ObjectMapper objectMapper;
    static final Map<String, Class<? extends Collection>> _collectionFallbacks = new HashMap<String, Class<? extends Collection>>();

    public DocumentReferenceDeserializerFactory(CouchDbConnector couchDbConnector, ObjectMapper objectMapper) throws JsonMappingException {
        super(null);
        this.couchDbConnector = couchDbConnector;
        this.objectMapper = objectMapper;
    }

    public JsonDeserializer<Object> createBeanDeserializer(DeserializationConfig config, DeserializerProvider p, JavaType type, BeanProperty property) throws JsonMappingException {
        BasicBeanDescription desc = (BasicBeanDescription)config.introspect(type);
        ArrayList<ConstructibleAnnotatedCollection> fields = new ArrayList<ConstructibleAnnotatedCollection>();
        BasicBeanDescription beanDesc = (BasicBeanDescription)config.introspect(type);
        LinkedHashMap setters = beanDesc.findSetters(this.getVisibilityChecker(config, beanDesc));
        for (AnnotatedField field : desc.getClassInfo().fields()) {
            if (!field.hasAnnotation(DocumentReferences.class)) continue;
            this.collectBackrefField(config, fields, beanDesc, setters, field);
        }
        if (fields.isEmpty()) {
            return super.createBeanDeserializer(config, p, type, property);
        }
        return new BackReferencedBeanDeserializer((BeanDeserializer)super.createBeanDeserializer(config, p, type, property), fields, this.couchDbConnector, type.getRawClass(), this.objectMapper);
    }

    private void collectBackrefField(DeserializationConfig config, List<ConstructibleAnnotatedCollection> fields, BasicBeanDescription beanDesc, Map<String, AnnotatedMethod> setters, AnnotatedField field) throws JsonMappingException {
        JavaType collectionType = field.getType(new TypeBindings(field.getDeclaringClass()));
        if (collectionType instanceof CollectionType) {
            Constructor<Collection<Object>> ctor = this.findCtor(config, (CollectionType)collectionType, field.getRawType());
            ConstructibleAnnotatedCollection cf = new ConstructibleAnnotatedCollection(field, ctor, this.constructSettableProperty(config, beanDesc, field.getName(), setters.get(field.getName())));
            fields.add(cf);
        }
    }

    protected VisibilityChecker<?> getVisibilityChecker(DeserializationConfig config, BasicBeanDescription beanDesc) {
        VisibilityChecker vchecker = config.getDefaultVisibilityChecker();
        if (!config.isEnabled(DeserializationConfig.Feature.AUTO_DETECT_SETTERS)) {
            vchecker = vchecker.withSetterVisibility(JsonAutoDetect.Visibility.NONE);
        }
        if (!config.isEnabled(DeserializationConfig.Feature.AUTO_DETECT_FIELDS)) {
            vchecker = vchecker.withFieldVisibility(JsonAutoDetect.Visibility.NONE);
        }
        vchecker = config.getAnnotationIntrospector().findAutoDetectVisibility(beanDesc.getClassInfo(), vchecker);
        return vchecker;
    }

    public boolean isSetter(Method method) {
        if (Modifier.isStatic(method.getModifiers())) {
            return false;
        }
        return method.getName().startsWith("set") && method.getParameterTypes().length == 1 && method.getReturnType().equals(Void.TYPE);
    }

    private Constructor<Collection<Object>> findCtor(DeserializationConfig config, CollectionType type, Class<?> clazz) {
        Class<Object> collectionClass = clazz;
        if (type.isInterface() || type.isAbstract()) {
            Class<? extends Collection> fallback = _collectionFallbacks.get(collectionClass.getName());
            if (fallback == null) {
                throw new IllegalArgumentException("Can not find a deserializer for non-concrete Collection type " + type);
            }
            collectionClass = fallback;
        }
        boolean fixAccess = config.isEnabled(DeserializationConfig.Feature.CAN_OVERRIDE_ACCESS_MODIFIERS);
        Constructor ctor = ClassUtil.findConstructor(collectionClass, (boolean)fixAccess);
        return ctor;
    }

    static {
        _collectionFallbacks.put(Collection.class.getName(), ArrayList.class);
        _collectionFallbacks.put(List.class.getName(), ArrayList.class);
        _collectionFallbacks.put(Set.class.getName(), LinkedHashSet.class);
        _collectionFallbacks.put(SortedSet.class.getName(), TreeSet.class);
        _collectionFallbacks.put(Queue.class.getName(), LinkedList.class);
        _collectionFallbacks.put("java.util.Deque", LinkedList.class);
        _collectionFallbacks.put("java.util.NavigableSet", TreeSet.class);
    }
}

