/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonAnySetter;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;
import org.ektorp.util.Assert;

public class DbInfo
implements Serializable {
    private static final long serialVersionUID = -6511885014968791685L;
    private final String dbName;
    @JsonProperty(value="compact_running")
    boolean compactRunning;
    @JsonProperty(value="disk_format_version")
    int diskFormatVersion;
    @JsonProperty(value="disk_size")
    long diskSize;
    @JsonProperty(value="doc_count")
    long docCount;
    @JsonProperty(value="doc_del_count")
    int docDelCount;
    @JsonProperty(value="instance_start_time")
    long instanceStartTime;
    @JsonProperty(value="purge_seq")
    int purgeSeq;
    @JsonProperty(value="update_seq")
    String updateSeq;
    private Map<String, Object> unknownFields;

    public boolean isCompactRunning() {
        return this.compactRunning;
    }

    public String getDbName() {
        return this.dbName;
    }

    public int getDiskFormatVersion() {
        return this.diskFormatVersion;
    }

    public long getDiskSize() {
        return this.diskSize;
    }

    public long getDocCount() {
        return this.docCount;
    }

    public int getDocDelCount() {
        return this.docDelCount;
    }

    public long getInstanceStartTime() {
        return this.instanceStartTime;
    }

    public int getPurgeSeq() {
        return this.purgeSeq;
    }

    public long getUpdateSeq() {
        return Long.parseLong(this.updateSeq);
    }

    public String getUpdateSeqAsString() {
        return this.updateSeq;
    }

    public boolean isUpdateSeqNumeric() {
        return this.updateSeq != null && this.updateSeq.matches("^\\d*$");
    }

    @JsonCreator
    public DbInfo(@JsonProperty(value="db_name") String dbName) {
        Assert.hasText(dbName, "dbName may not be null or empty");
        this.dbName = dbName;
    }

    @JsonAnySetter
    public void setUnknown(String key, Object value) {
        this.unknownFields().put(key, value);
    }

    public Map<String, Object> getUnknownFields() {
        return this.unknownFields();
    }

    private Map<String, Object> unknownFields() {
        if (this.unknownFields == null) {
            this.unknownFields = new HashMap<String, Object>();
        }
        return this.unknownFields;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DbInfo) {
            DbInfo dbi = (DbInfo)o;
            return this.dbName.equals(dbi.dbName);
        }
        return false;
    }

    public int hashCode() {
        return this.dbName.hashCode();
    }
}

