/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.impl;

import java.io.OutputStream;
import java.util.Collection;
import org.apache.commons.io.IOUtils;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.ObjectMapper;
import org.ektorp.util.Exceptions;

public class BulkDocumentWriter {
    private final ObjectMapper objectMapper;

    public BulkDocumentWriter(ObjectMapper om) {
        this.objectMapper = om;
    }

    public void write(Collection<?> objects, boolean allOrNothing, OutputStream out) {
        try {
            JsonGenerator jg = this.objectMapper.getJsonFactory().createJsonGenerator(out, JsonEncoding.UTF8);
            jg.writeStartObject();
            if (allOrNothing) {
                jg.writeBooleanField("all_or_nothing", true);
            }
            jg.writeArrayFieldStart("docs");
            for (Object o : objects) {
                jg.writeObject(o);
            }
            jg.writeEndArray();
            jg.writeEndObject();
            jg.flush();
            jg.close();
        }
        catch (Exception e) {
            throw Exceptions.propagate(e);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
        }
    }
}

