/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.impl.jackson;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.BeanProperty;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.TypeDeserializer;
import org.codehaus.jackson.map.deser.BeanDeserializer;
import org.codehaus.jackson.map.deser.BeanDeserializerBuilder;
import org.codehaus.jackson.map.deser.BeanDeserializerModifier;
import org.codehaus.jackson.map.deser.SettableBeanProperty;
import org.codehaus.jackson.map.introspect.AnnotatedMember;
import org.codehaus.jackson.map.introspect.AnnotatedMethod;
import org.codehaus.jackson.map.introspect.BasicBeanDescription;
import org.codehaus.jackson.map.introspect.VisibilityChecker;
import org.codehaus.jackson.map.type.CollectionType;
import org.codehaus.jackson.map.util.ClassUtil;
import org.codehaus.jackson.type.JavaType;
import org.ektorp.CouchDbConnector;
import org.ektorp.docref.DocumentReferences;
import org.ektorp.impl.docref.BackReferencedBeanDeserializer;
import org.ektorp.impl.docref.ConstructibleAnnotatedCollection;
import org.ektorp.util.Predicate;
import org.ektorp.util.ReflectionUtils;

public class EktorpBeanDeserializerModifier
extends BeanDeserializerModifier {
    private final CouchDbConnector db;
    private final ObjectMapper objectMapper;
    static final Map<String, Class<? extends Collection>> _collectionFallbacks = new HashMap<String, Class<? extends Collection>>();

    public EktorpBeanDeserializerModifier(CouchDbConnector db, ObjectMapper objectMapper) {
        this.db = db;
        this.objectMapper = objectMapper;
    }

    public JsonDeserializer<?> modifyDeserializer(DeserializationConfig config, BasicBeanDescription beanDesc, JsonDeserializer<?> deserializer) {
        List<ConstructibleAnnotatedCollection> fields;
        if (deserializer instanceof BeanDeserializer && !(fields = this.collectFields(config, beanDesc)).isEmpty()) {
            return new BackReferencedBeanDeserializer((BeanDeserializer)deserializer, fields, this.db, beanDesc.getType().getRawClass(), this.objectMapper);
        }
        return super.modifyDeserializer(config, beanDesc, deserializer);
    }

    private List<ConstructibleAnnotatedCollection> collectFields(final DeserializationConfig config, final BasicBeanDescription desc) {
        final ArrayList<ConstructibleAnnotatedCollection> fields = new ArrayList<ConstructibleAnnotatedCollection>();
        final LinkedHashMap setters = desc.findSetters(this.getVisibilityChecker(config, desc));
        ReflectionUtils.eachField(desc.getType().getRawClass(), new Predicate<Field>(){

            @Override
            public boolean apply(Field input) {
                ConstructibleAnnotatedCollection c;
                if (ReflectionUtils.hasAnnotation(input, DocumentReferences.class) && (c = EktorpBeanDeserializerModifier.this.collectBackrefField(config, desc, setters, input)) != null) {
                    fields.add(c);
                }
                return false;
            }
        });
        return fields;
    }

    private ConstructibleAnnotatedCollection collectBackrefField(DeserializationConfig config, BasicBeanDescription beanDesc, Map<String, AnnotatedMethod> setters, Field field) {
        JavaType type = this.objectMapper.getTypeFactory().constructType(field.getGenericType());
        if (!(type instanceof CollectionType)) {
            return null;
        }
        CollectionType collectionType = (CollectionType)type;
        return new ConstructibleAnnotatedCollection(field, this.findCtor(config, collectionType, field.getType()), this.constructSettableProperty(config, beanDesc, field.getName(), setters.get(field.getName()), (JavaType)collectionType), collectionType);
    }

    private VisibilityChecker<?> getVisibilityChecker(DeserializationConfig config, BasicBeanDescription beanDesc) {
        VisibilityChecker vchecker = config.getDefaultVisibilityChecker();
        if (!config.isEnabled(DeserializationConfig.Feature.AUTO_DETECT_SETTERS)) {
            vchecker = vchecker.withSetterVisibility(JsonAutoDetect.Visibility.NONE);
        }
        if (!config.isEnabled(DeserializationConfig.Feature.AUTO_DETECT_FIELDS)) {
            vchecker = vchecker.withFieldVisibility(JsonAutoDetect.Visibility.NONE);
        }
        vchecker = config.getAnnotationIntrospector().findAutoDetectVisibility(beanDesc.getClassInfo(), vchecker);
        return vchecker;
    }

    protected SettableBeanProperty constructSettableProperty(DeserializationConfig config, BasicBeanDescription beanDesc, String name, AnnotatedMethod setter, JavaType type) {
        if (config.isEnabled(DeserializationConfig.Feature.CAN_OVERRIDE_ACCESS_MODIFIERS)) {
            setter.fixAccess();
        }
        JavaType t0 = beanDesc.bindingsForBeanType().resolveType(setter.getParameterType(0));
        BeanProperty.Std property = new BeanProperty.Std(name, t0, beanDesc.getClassAnnotations(), (AnnotatedMember)setter);
        if (type != t0) {
            property = property.withType(type);
        }
        TypeDeserializer typeDeser = (TypeDeserializer)type.getTypeHandler();
        SettableBeanProperty.MethodProperty prop = new SettableBeanProperty.MethodProperty(name, type, typeDeser, beanDesc.getClassAnnotations(), setter);
        AnnotationIntrospector.ReferenceProperty ref = config.getAnnotationIntrospector().findReferenceType((AnnotatedMember)setter);
        if (ref != null && ref.isManagedReference()) {
            prop.setManagedReferenceName(ref.getName());
        }
        return prop;
    }

    private Constructor<Collection<Object>> findCtor(DeserializationConfig config, CollectionType type, Class<?> clazz) {
        Class<Object> collectionClass = clazz;
        if (type.isInterface() || type.isAbstract()) {
            Class<? extends Collection> fallback = _collectionFallbacks.get(collectionClass.getName());
            if (fallback == null) {
                throw new IllegalArgumentException("Can not find a deserializer for non-concrete Collection type " + type);
            }
            collectionClass = fallback;
        }
        boolean fixAccess = config.isEnabled(DeserializationConfig.Feature.CAN_OVERRIDE_ACCESS_MODIFIERS);
        Constructor ctor = ClassUtil.findConstructor(collectionClass, (boolean)fixAccess);
        return ctor;
    }

    public BeanDeserializerBuilder updateBuilder(DeserializationConfig config, BasicBeanDescription beanDesc, BeanDeserializerBuilder builder) {
        return super.updateBuilder(config, beanDesc, builder);
    }

    static {
        _collectionFallbacks.put(Collection.class.getName(), ArrayList.class);
        _collectionFallbacks.put(List.class.getName(), ArrayList.class);
        _collectionFallbacks.put(Set.class.getName(), LinkedHashSet.class);
        _collectionFallbacks.put(SortedSet.class.getName(), TreeSet.class);
        _collectionFallbacks.put(Queue.class.getName(), LinkedList.class);
        _collectionFallbacks.put("java.util.Deque", LinkedList.class);
        _collectionFallbacks.put("java.util.NavigableSet", TreeSet.class);
    }
}

