/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.impl;

import java.util.Locale;

public class NameConventions {
    private static final String BACK_REF_VIEW_NAME = "ektorp_docrefs_%s";
    private static final String DESIGN_DOC_NAME_FOR_TYPE = "_design/%s";

    private NameConventions() {
    }

    public static String backReferenceViewName(String fieldName) {
        return String.format(BACK_REF_VIEW_NAME, fieldName);
    }

    public static String designDocName(Class<?> klass) {
        return String.format(DESIGN_DOC_NAME_FOR_TYPE, klass.getSimpleName());
    }

    public static String designDocName(String docName) {
        return String.format(DESIGN_DOC_NAME_FOR_TYPE, docName);
    }

    public static String getterName(String property) {
        return "get" + NameConventions.capitalize(property);
    }

    public static String capitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        return name.substring(0, 1).toUpperCase(Locale.ENGLISH) + name.substring(1);
    }
}

