/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.impl;

import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.codehaus.jackson.map.ObjectMapper;
import org.ektorp.impl.BulkDocumentWriter;
import org.ektorp.impl.BulkOperation;
import org.ektorp.impl.JsonSerializer;
import org.ektorp.util.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamingJsonSerializer
implements JsonSerializer {
    private final Logger LOG = LoggerFactory.getLogger(StreamingJsonSerializer.class);
    private final ObjectMapper objectMapper;
    private final BulkDocumentWriter bulkDocWriter;
    private static ExecutorService singletonExecutorService;
    private final ExecutorService executorService;

    public StreamingJsonSerializer(ObjectMapper om) {
        this(om, StreamingJsonSerializer.getSingletonExecutorService());
    }

    public StreamingJsonSerializer(ObjectMapper om, ExecutorService es) {
        this.objectMapper = om;
        this.executorService = es;
        this.bulkDocWriter = new BulkDocumentWriter(om);
    }

    private static synchronized ExecutorService getSingletonExecutorService() {
        if (singletonExecutorService == null) {
            singletonExecutorService = Executors.newCachedThreadPool(new ThreadFactory(){
                private final AtomicInteger threadCount = new AtomicInteger();

                @Override
                public Thread newThread(Runnable r) {
                    return new Thread(r, String.format("ektorp-doc-writer-thread-%s", this.threadCount.incrementAndGet()));
                }
            });
        }
        return singletonExecutorService;
    }

    @Override
    public BulkOperation createBulkOperation(final Collection<?> objects, final boolean allOrNothing) {
        try {
            final PipedOutputStream out = new PipedOutputStream();
            PipedInputStream in = new PipedInputStream(out);
            Future<?> writeTask = this.executorService.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        StreamingJsonSerializer.this.bulkDocWriter.write(objects, allOrNothing, out);
                    }
                    catch (Exception e) {
                        StreamingJsonSerializer.this.LOG.error("Caught exception while writing bulk document:", (Throwable)e);
                    }
                }
            });
            return new BulkOperation(writeTask, in);
        }
        catch (IOException e) {
            throw Exceptions.propagate(e);
        }
    }

    @Override
    public String toJson(Object o) {
        try {
            if (this.LOG.isDebugEnabled()) {
                String json = this.objectMapper.writeValueAsString(o);
                this.LOG.debug(json);
                return json;
            }
            return this.objectMapper.writeValueAsString(o);
        }
        catch (Exception e) {
            throw Exceptions.propagate(e);
        }
    }
}

