/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Deque;
import java.util.LinkedList;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;
import org.codehaus.jackson.node.ObjectNode;
import org.ektorp.ViewQuery;
import org.ektorp.util.Base64;
import org.ektorp.util.Exceptions;

public class PageRequest {
    private static final String NEXT_KEY_FIELD_NAME = "k";
    private static final String KEY_HISTORY_FIELD_NAME = "h";
    private static final String PAGE_SIZE_FIELD_NAME = "s";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final KeyIdPair FIRST_PAGE_NEXT_KEY_PLACEHOLDER = new KeyIdPair((JsonNode)NullNode.instance, "_ektorp_1k");
    private final int pageSize;
    private final KeyIdPair nextKey;
    private final Deque<KeyIdPair> keyHistory;

    public static ViewQuery applyPagingParameters(ViewQuery q, PageRequest pr) {
        if (pr.getStartKey() != null) {
            q.startKey(pr.getStartKey());
        }
        if (pr.getStartKeyDocId() != null) {
            q.startDocId(pr.getStartKeyDocId());
        }
        return q.limit(pr.getPageSize() + 1);
    }

    public static PageRequest firstPage(int pageSize) {
        return new PageRequest(null, pageSize, new LinkedList<KeyIdPair>());
    }

    private PageRequest(KeyIdPair nextKey, int pageSize, Deque<KeyIdPair> keyHistory) {
        this.nextKey = nextKey;
        this.pageSize = pageSize;
        this.keyHistory = keyHistory;
    }

    public static PageRequest fromLink(String link) {
        try {
            JsonNode n = MAPPER.readTree((InputStream)new ByteArrayInputStream(Base64.decode(link, 16)));
            KeyIdPair key = PageRequest.parseNextKey(n);
            Deque<KeyIdPair> keyHistory = PageRequest.parseKeyHistory(n);
            int pageSize = n.get(PAGE_SIZE_FIELD_NAME).getIntValue();
            return new PageRequest(key, pageSize, keyHistory);
        }
        catch (Exception e) {
            throw Exceptions.propagate(e);
        }
    }

    private static Deque<KeyIdPair> parseKeyHistory(JsonNode n) {
        LinkedList<KeyIdPair> keyHistory = new LinkedList<KeyIdPair>();
        ArrayNode h = (ArrayNode)n.get(KEY_HISTORY_FIELD_NAME);
        if (h != null) {
            for (JsonNode hn : h) {
                String docId = (String)hn.getFieldNames().next();
                keyHistory.addFirst(new KeyIdPair(hn.get(docId), docId));
            }
        }
        return keyHistory;
    }

    private static KeyIdPair parseNextKey(JsonNode n) {
        KeyIdPair key;
        JsonNode nextKey = n.get(NEXT_KEY_FIELD_NAME);
        if (nextKey != null) {
            String docId = (String)nextKey.getFieldNames().next();
            key = new KeyIdPair(nextKey.get(docId), docId);
        } else {
            key = null;
        }
        return key;
    }

    public String asLink() {
        try {
            return Base64.encodeBytes(MAPPER.writeValueAsBytes((Object)this.asJson()), 16);
        }
        catch (Exception e) {
            throw Exceptions.propagate(e);
        }
    }

    public JsonNode asJson() {
        ObjectNode n = MAPPER.createObjectNode();
        if (this.nextKey != null) {
            n.putObject(NEXT_KEY_FIELD_NAME).put(this.nextKey.docId, this.nextKey.key);
        }
        n.put(PAGE_SIZE_FIELD_NAME, this.pageSize);
        if (!this.keyHistory.isEmpty()) {
            ArrayNode h = n.putArray(KEY_HISTORY_FIELD_NAME);
            for (KeyIdPair k : this.keyHistory) {
                h.addObject().put(k.docId, k.key);
            }
        }
        return n;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public Object getStartKey() {
        return this.nextKey != null ? this.nextKey.key : null;
    }

    public String getStartKeyDocId() {
        return this.nextKey != null ? this.nextKey.docId : null;
    }

    public PageRequest getPreviousPageRequest() {
        LinkedList<KeyIdPair> d = new LinkedList<KeyIdPair>(this.keyHistory);
        KeyIdPair previousKey = (KeyIdPair)d.pollFirst();
        if (previousKey == null) {
            return null;
        }
        if (FIRST_PAGE_NEXT_KEY_PLACEHOLDER.equals(previousKey)) {
            d.clear();
            previousKey = null;
        }
        return new PageRequest(previousKey, this.pageSize, d);
    }

    public PageRequest getNextPageRequest(Object nextStartKey, String nextStartDocId) {
        try {
            JsonNode keyNode = MAPPER.readTree(MAPPER.writeValueAsString(nextStartKey));
            LinkedList<KeyIdPair> d = new LinkedList<KeyIdPair>(this.keyHistory);
            d.addFirst(this.nextKey != null ? this.nextKey : FIRST_PAGE_NEXT_KEY_PLACEHOLDER);
            return new PageRequest(new KeyIdPair(keyNode, nextStartDocId), this.pageSize, d);
        }
        catch (IOException e) {
            throw Exceptions.propagate(e);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.keyHistory == null ? 0 : this.keyHistory.size());
        result = 31 * result + (this.nextKey == null ? 0 : this.nextKey.hashCode());
        result = 31 * result + this.pageSize;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PageRequest other = (PageRequest)obj;
        if (this.keyHistory == null ? other.keyHistory != null : this.keyHistory.size() != other.keyHistory.size()) {
            return false;
        }
        if (this.nextKey == null ? other.nextKey != null : !this.nextKey.equals(other.nextKey)) {
            return false;
        }
        return this.pageSize == other.pageSize;
    }

    public String toString() {
        return this.asJson().toString();
    }

    private static final class KeyIdPair {
        final JsonNode key;
        final String docId;

        KeyIdPair(JsonNode key, String docId) {
            this.key = key;
            this.docId = docId;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.docId == null ? 0 : this.docId.hashCode());
            result = 31 * result + (this.key == null ? 0 : this.key.toString().hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            KeyIdPair other = (KeyIdPair)obj;
            if (this.docId == null ? other.docId != null : !this.docId.equals(other.docId)) {
                return false;
            }
            return !(this.key == null ? other.key != null : !this.key.toString().equals(other.key.toString()));
        }
    }
}

