/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.impl;

import java.io.IOException;
import java.util.List;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.ektorp.CouchDbConnector;
import org.ektorp.CouchDbInstance;
import org.ektorp.DbAccessException;
import org.ektorp.DbPath;
import org.ektorp.ReplicationCommand;
import org.ektorp.ReplicationStatus;
import org.ektorp.http.HttpClient;
import org.ektorp.http.HttpResponse;
import org.ektorp.http.RestTemplate;
import org.ektorp.http.StdResponseHandler;
import org.ektorp.impl.ObjectMapperFactory;
import org.ektorp.impl.StdCouchDbConnector;
import org.ektorp.impl.StdObjectMapperFactory;
import org.ektorp.util.Assert;
import org.ektorp.util.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StdCouchDbInstance
implements CouchDbInstance {
    private static final Logger LOG = LoggerFactory.getLogger(StdCouchDbInstance.class);
    private static final TypeReference<List<String>> STRING_LIST_TYPE_DEF = new TypeReference<List<String>>(){};
    private final HttpClient client;
    private final RestTemplate restTemplate;
    private final ObjectMapper objectMapper;
    private final ObjectMapperFactory objectMapperFactory;

    public StdCouchDbInstance(HttpClient client) {
        this(client, new StdObjectMapperFactory());
    }

    public StdCouchDbInstance(HttpClient client, ObjectMapperFactory of) {
        Assert.notNull(client, "HttpClient may not be null");
        Assert.notNull(of, "ObjectMapperFactory may not be null");
        this.client = client;
        this.restTemplate = new RestTemplate(client);
        this.objectMapper = of.createObjectMapper();
        this.objectMapperFactory = of;
    }

    @Override
    public void createDatabase(String path) {
        this.createDatabase(DbPath.fromString(path));
    }

    @Override
    public void createDatabase(DbPath db) {
        if (this.checkIfDbExists(db)) {
            throw new DbAccessException(String.format("A database with path %s already exists", db.getPath()));
        }
        LOG.debug("creating db path: {}", (Object)db.getPath());
        this.restTemplate.put(db.getPath());
    }

    @Override
    public void deleteDatabase(String path) {
        Assert.notNull(path);
        this.restTemplate.delete(DbPath.fromString(path).getPath());
    }

    @Override
    public boolean checkIfDbExists(DbPath db) {
        return this.restTemplate.head(db.getPath(), new StdResponseHandler<Boolean>(){

            @Override
            public Boolean error(HttpResponse hr) {
                return false;
            }

            @Override
            public Boolean success(HttpResponse hr) throws Exception {
                return true;
            }
        });
    }

    @Override
    public List<String> getAllDatabases() {
        return this.restTemplate.get("/_all_dbs", new StdResponseHandler<List<String>>(){

            @Override
            public List<String> success(HttpResponse hr) throws Exception {
                return (List)StdCouchDbInstance.this.objectMapper.readValue(hr.getContent(), STRING_LIST_TYPE_DEF);
            }
        });
    }

    @Override
    public ReplicationStatus replicate(ReplicationCommand cmd) {
        try {
            return this.restTemplate.post("/_replicate", this.objectMapper.writeValueAsString((Object)cmd), new StdResponseHandler<ReplicationStatus>(){

                @Override
                public ReplicationStatus success(HttpResponse hr) throws Exception {
                    return (ReplicationStatus)StdCouchDbInstance.this.objectMapper.readValue(hr.getContent(), ReplicationStatus.class);
                }
            });
        }
        catch (IOException e) {
            throw Exceptions.propagate(e);
        }
    }

    @Override
    public HttpClient getConnection() {
        return this.client;
    }

    @Override
    public CouchDbConnector createConnector(String path, boolean createIfNotExists) {
        StdCouchDbConnector db = new StdCouchDbConnector(path, this, this.objectMapperFactory);
        if (createIfNotExists) {
            db.createDatabaseIfNotExists();
        }
        return db;
    }
}

