/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp;

import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.ObjectMapper;
import org.ektorp.DbAccessException;
import org.ektorp.changes.DocumentChange;
import org.ektorp.http.HttpResponse;
import org.ektorp.impl.changes.StdDocumentChange;

public class StreamingChangesResult
implements Serializable,
Iterable<DocumentChange>,
Closeable {
    private static final long serialVersionUID = 4750290767936801714L;
    private boolean iteratorCalled;
    private JsonParser jp;
    private long lastSeq = -1L;
    private final HttpResponse response;

    public StreamingChangesResult(ObjectMapper objectMapper, HttpResponse response) {
        this.response = response;
        try {
            this.jp = objectMapper.getJsonFactory().createJsonParser(response.getContent());
            this.jp.nextValue();
            this.jp.nextValue();
            this.jp.nextToken();
        }
        catch (Exception e) {
            throw new DbAccessException(e);
        }
    }

    @Override
    public Iterator<DocumentChange> iterator() {
        if (this.iteratorCalled) {
            throw new IllegalStateException("Iterator can only be called once!");
        }
        this.iteratorCalled = true;
        return new StreamingResultIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        try {
            this.response.abort();
        }
        finally {
            this.close();
        }
    }

    @Override
    public void close() {
        try {
            this.jp.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public long getLastSeq() {
        if (this.lastSeq == -1L) {
            throw new IllegalStateException("Last seq can only be called after stream is fully iterated");
        }
        return this.lastSeq;
    }

    private class StreamingResultIterator
    implements Iterator<DocumentChange> {
        private DocumentChange row;

        private StreamingResultIterator() {
        }

        @Override
        public boolean hasNext() {
            try {
                JsonNode jsonNode = (JsonNode)StreamingChangesResult.this.jp.readValueAs(JsonNode.class);
                if (jsonNode == null) {
                    jsonNode = (JsonNode)StreamingChangesResult.this.jp.readValueAs(JsonNode.class);
                    StreamingChangesResult.this.lastSeq = jsonNode.get("last_seq").getLongValue();
                    StreamingChangesResult.this.close();
                    return false;
                }
                this.row = new StdDocumentChange(jsonNode);
                return true;
            }
            catch (Exception e) {
                throw new DbAccessException(e);
            }
        }

        @Override
        public DocumentChange next() {
            return this.row;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

