/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.io.IOUtils;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.ObjectMapper;
import org.ektorp.util.Exceptions;

public class BulkDocumentWriter {
    private final ObjectMapper objectMapper;

    public BulkDocumentWriter(ObjectMapper om) {
        this.objectMapper = om;
    }

    public void write(Collection<?> objects, boolean allOrNothing, OutputStream out) {
        try {
            JsonGenerator jg = this.objectMapper.getJsonFactory().createJsonGenerator(out, JsonEncoding.UTF8);
            jg.writeStartObject();
            if (allOrNothing) {
                jg.writeBooleanField("all_or_nothing", true);
            }
            jg.writeArrayFieldStart("docs");
            for (Object o : objects) {
                jg.writeObject(o);
            }
            jg.writeEndArray();
            jg.writeEndObject();
            jg.flush();
            jg.close();
        }
        catch (Exception e) {
            throw Exceptions.propagate(e);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    public InputStream createInputStreamWrapper(boolean allOrNothing, InputStream in) {
        ArrayList<InputStream> seq = new ArrayList<InputStream>(3);
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            JsonGenerator jg = this.objectMapper.getJsonFactory().createJsonGenerator((OutputStream)byteArrayOutputStream, JsonEncoding.UTF8);
            jg.writeStartObject();
            if (allOrNothing) {
                jg.writeBooleanField("all_or_nothing", true);
            }
            jg.writeFieldName("docs");
            jg.writeRaw(':');
            jg.flush();
            seq.add(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            seq.add(in);
            byteArrayOutputStream.reset();
            jg.writeEndObject();
            jg.flush();
            jg.close();
            seq.add(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
        }
        catch (Exception e) {
            throw Exceptions.propagate(e);
        }
        return new SequenceInputStream(Collections.enumeration(seq));
    }
}

